<?php

namespace App\Http\Controllers\Admin;

use App\Models\CustomerContact;
use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerContactController extends Controller
{
    public function create(Customer $customer)
    {
        return view('contacts.create', compact('customer'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'customer_id' => 'required|exists:customers,id',
            'name' => 'required|string',
            'designation' => 'nullable|string',
            'email' => 'nullable|email',
            'mobile1' => 'nullable|string',
            'mobile2' => 'nullable|string',
            'mobile3' => 'nullable|string',
        ]);

        CustomerContact::create($validated);
        return back()->with('success', 'Contact added.');
    }

    public function destroy(CustomerContact $customerContact)
    {
        $customerContact->delete();
        return back()->with('success', 'Contact deleted.');
    }
}
namespace App\Http\Controllers;

use App\Models\CustomerContact;
use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerContactController extends Controller
{
    public function create(Customer $customer)
    {
        return view('contacts.create', compact('customer'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'customer_id' => 'required|exists:customers,id',
            'name' => 'required|string',
            'designation' => 'nullable|string',
            'email' => 'nullable|email',
            'mobile1' => 'nullable|string',
            'mobile2' => 'nullable|string',
            'mobile3' => 'nullable|string',
        ]);

        CustomerContact::create($validated);
        return back()->with('success', 'Contact added.');
    }

    public function destroy(CustomerContact $customerContact)
    {
        $customerContact->delete();
        return back()->with('success', 'Contact deleted.');
    }
}
