<?php

namespace App\Http\Controllers\Admin;

use App\Models\Quote;
use App\Models\Customer;
use Illuminate\Http\Request;

class QuoteController extends Controller
{
    public function index()
    {
        $quotes = Quote::with('customer')->get();
        return view('quotes.index', compact('quotes'));
    }

    public function create()
    {
        $customers = Customer::all();
        return view('quotes.create', compact('customers'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'quote_number' => 'required|unique:quotes',
            'customer_id' => 'required|exists:customers,id',
            'quote_date' => 'required|date',
            'project_site' => 'nullable|string',
            'subtotal' => 'required|numeric',
            'discount' => 'required|numeric',
            'taxable_total' => 'required|numeric',
            'tax' => 'required|numeric',
            'total' => 'required|numeric',
        ]);

        Quote::create($validated);
        return redirect()->route('quotes.index')->with('success', 'Quote created.');
    }

    public function edit(Quote $quote)
    {
        $customers = Customer::all();
        return view('quotes.edit', compact('quote', 'customers'));
    }

    public function update(Request $request, Quote $quote)
    {
        $validated = $request->validate([
            'quote_date' => 'required|date',
            'customer_id' => 'required|exists:customers,id',
            'project_site' => 'nullable|string',
            'subtotal' => 'required|numeric',
            'discount' => 'required|numeric',
            'taxable_total' => 'required|numeric',
            'tax' => 'required|numeric',
            'total' => 'required|numeric',
        ]);

        $quote->update($validated);
        return redirect()->route('quotes.index')->with('success', 'Quote updated.');
    }

    public function destroy(Quote $quote)
    {
        $quote->delete();
        return redirect()->route('quotes.index')->with('success', 'Quote deleted.');
    }
}

