<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\JournalEntry;
use App\Models\JournalTransaction;
use App\Models\Account;
use App\Models\Vendor;
use App\Models\Equipment;
use App\Models\Invoice;

class JournalExpenseController extends Controller
{
    public function create()
    {


        $expenseAccounts = Account::whereIn('code', [5001, 5002, 6001, 6002])->get();
        $cashAccounts = Account::whereIn('code', [1001, 1002, 1003])->get();
        $vendors = Vendor::all();
        $equipments = Equipment::all();
        $invoices = Invoice::whereIn('status', ['created', 'submitted'])->get();

        return view('admin.journals.record-expense', compact('expenseAccounts', 'cashAccounts', 'vendors', 'equipments', 'invoices'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required|date',
            'description' => 'required|string',
            'allocation' => 'nullable|string',
            'inv_number' => 'required|string',
            'inv_date' => 'required|date',
            'vendor_id' => 'nullable|exists:vendors,id',
            'machine_id' => 'nullable|exists:equipment,id',
            'debit_account_id' => 'required|exists:accounts,id',
            'credit_account_id' => 'required|exists:accounts,id',
            'amount' => 'required|numeric|min:0.01',
        ]);

        $journal = JournalEntry::create([
            'user_id' => auth()->id(),
            'date' => $request->date,
            'description' => $request->description,
            'allocation' => $request->allocation,
            'inv_number' => $request->inv_id,
            'inv_date' => $request->inv_date,
            'vendor_id' => $request->vendor_id,
            'machine_id' => $request->machine_id,
        ]);

        $amount = number_format($request->amount, 2, '.', '');

        $journal->transactions()->create([
            'user_id' => auth()->id(),
            'account_id' => $request->debit_account_id,
            'debit' => $request->amount,
            'credit' => 0,
            'user_id' => auth()->id(),
        ]);

        $journal->transactions()->create([
            'user_id' => auth()->id(),
            'account_id' => $request->credit_account_id,
            'debit' => 0,
            'credit' => $request->amount,

        ]);

        return redirect()->route('admin.journals.index')->with('success', 'Journal entry posted.');
    }
}
