<?php

namespace App\Http\Controllers\Admin;

use App\Models\VendorContact;
use App\Models\Vendor;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class VendorContactController extends Controller
{
    public function index()
    {
        $contacts = VendorContact::with('vendor')->get();
        return view('admin.vendor_contacts.index', compact('contacts'));
    }

    public function create()
    {
        $vendors = Vendor::all();
        return view('admin.vendor_contacts.create', compact('vendors'));
    }

    public function store(Request $request)
    {
        VendorContact::create($request->all());
        return redirect()->route('vendor_contacts.index')->with('success', 'Contact added.');
    }

    public function edit(VendorContact $vendor_contact)
    {
        $vendors = Vendor::all();
        return view('admin.vendor_contacts.edit', compact('vendor_contact', 'vendors'));
    }

    public function update(Request $request, VendorContact $vendor_contact)
    {
        $vendor_contact->update($request->all());
        return redirect()->route('vendor_contacts.index')->with('success', 'Contact updated.');
    }

    public function destroy(VendorContact $vendor_contact)
    {
        $vendor_contact->delete();
        return back()->with('success', 'Contact deleted.');
    }
}

