<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CustomerContact extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'name',
        'designation',
        'email',
        'mobile1',
        'mobile2',
        'mobile3',
    ];

    // Relationships
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}

