<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class InvoiceItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_id',
        'item_code',
        'description',
        'quantity',
        'unit_price',
        'duration',
        'duration_unit',
        'line_total',
        'tax',
        'line_total_with_tax',
    ];

    // Relationships

    // Each invoice item belongs to one invoice
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    // Each invoice item is linked to one item by code (string foreign key)
    public function item()
    {
        return $this->belongsTo(Item::class, 'item_code', 'code');
    }
}
