<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Payroll extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'year',
        'month',
        'basic_salary',
        'allowances',
        'overtime',
        'bonuses',
        'gross_salary',
        'deductions',
        'net_salary',
        'working_days',
        'present_days',
        'leave_days',
        'status',
        'payment_date',
        'processed_by',
        'journal_entry_id',
    ];

    protected $casts = [
        'payment_date' => 'date',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function processor()
    {
        return $this->belongsTo(User::class, 'processed_by');
    }

    public function journalEntry()
    {
        return $this->belongsTo(JournalEntry::class);
    }

    public function items()
    {
        return $this->hasMany(PayrollItem::class);
    }
}
