<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Quote extends Model
{
    use HasFactory;

    protected $fillable = [
        'quote_number',
        'customer_id',
        'quote_date',
        'project_site',
        'subtotal',
        'discount',
        'taxable_total',
        'tax',
        'total',
    ];

    // Relationships

    // A quote belongs to a customer
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    // A quote can be used in many invoices
    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }
}


