<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Auth;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Configure AdminLTE menu based on user role
        // Target all views to ensure menu is always loaded
        View::composer('*', function () {
            if (Auth::check()) {
                $menuConfig = Auth::user()->hasRole('admin')
                    ? include config_path('admin_sidebar_menu.php')
                    : include config_path('user_sidebar_menu.php');

                config(['adminlte.menu' => $menuConfig]);
            }
        });
    }
}
