<?php

return [
        // Navbar items:
        [
            'type' => 'navbar-search',
            'text' => 'search',
            'topnav_right' => true,
        ],
        [
            'type' => 'fullscreen-widget',
            'topnav_right' => true,
        ],

        // Sidebar items:
        [
            'type' => 'sidebar-menu-search',
            'text' => 'search',
        ],

        // User Management
        [
            'text' => 'User Management',
            'icon' => 'fas fa-users',
            'can'  => 'manage users',
            'submenu' => [
                [
                    'text' => 'All Users',
                    'url'  => 'admin/users',
                    'icon' => 'fas fa-list',
                ],
                [
                    'text' => 'Add New User',
                    'url'  => 'admin/users/create',
                    'icon' => 'fas fa-user-plus',
                ],
            ],
        ],

        // Roles & Permissions
        ['header' => 'System Settings'],

        [
            'text' => 'Roles & Permissions',
            'icon' => 'fas fa-shield-alt',
            'can'  => 'manage users',
            'submenu' => [
                [
                    'text' => 'Roles',
                    'url'  => 'admin/roles',
                    'icon' => 'fas fa-user-shield',
                ],
                [
                    'text' => 'Permissions',
                    'url'  => 'admin/permissions',
                    'icon' => 'fas fa-key',
                ],
            ],
        ],

        // HR Module
        ['header' => 'HR Management'],

        // Employees
        [
            'text' => 'Employees',
            'icon' => 'fas fa-id-card',
            'can'  => 'view employees',
            'submenu' => [
                [
                    'text' => 'All Employees',
                    'url'  => 'admin/hr/employees',
                    'can'  => 'view employees',
                ],
                [
                    'text' => 'Add Employee',
                    'url'  => 'admin/hr/employees/create',
                    'can'  => 'create employees',
                ],
                [
                    'text' => 'Departments',
                    'url'  => 'admin/hr/departments',
                    'can'  => 'manage departments',
                ],
                [
                    'text' => 'Designations',
                    'url'  => 'admin/hr/designations',
                    'can'  => 'manage designations',
                ],
            ],
        ],

        // Attendance
        [
            'text' => 'Attendance',
            'icon' => 'fas fa-calendar-check',
            'can'  => 'mark own attendance',
            'submenu' => [
                [
                    'text' => 'Mark Attendance',
                    'url'  => 'admin/hr/attendance/mark',
                    'can'  => 'mark own attendance',
                ],
                [
                    'text' => 'View Attendance',
                    'url'  => 'admin/hr/attendance',
                    'can'  => 'view attendance',
                ],
                [
                    'text' => 'Approve Attendance',
                    'url'  => 'admin/hr/attendance/approve',
                    'can'  => 'approve attendance',
                ],
            ],
        ],

        // Leave Management
        [
            'text' => 'Leave Management',
            'icon' => 'fas fa-umbrella-beach',
            'can'  => 'apply leave',
            'submenu' => [
                [
                    'text' => 'My Leaves',
                    'url'  => 'admin/hr/leaves',
                    'can'  => 'view own leaves',
                ],
                [
                    'text' => 'Apply Leave',
                    'url'  => 'admin/hr/leaves/create',
                    'can'  => 'apply leave',
                ],
                [
                    'text' => 'All Leave Applications',
                    'url'  => 'admin/hr/leaves/all',
                    'can'  => 'view all leaves',
                ],
            ],
        ],

        ['header' => 'Accounting'],

        // Accounts
        [
            'text' => 'Accounts',
            'icon' => 'fas fa-book',
            'can'  => 'manage accounts',
            'submenu' => [
                [
                    'text' => 'View Accounts',
                    'url'  => 'admin/accounts',
                ],
                [
                    'text' => 'Create Account',
                    'url'  => 'admin/accounts/create',
                ],
            ],
        ],

        // Petty Cash - Admin View
        [
            'text' => 'Petty Cash Admin',
            'icon' => 'fas fa-wallet',
            'can'  => 'view petty cash',
            'submenu' => [
                [
                    'text' => 'Petty Cash Overview',
                    'url'  => 'admin/petty-cash',
                    'can'  => 'view petty cash',
                ],
                [
                    'text' => 'Petty Cash Approvals',
                    'url'  => 'admin/pettycash/approvals',
                    'icon' => 'fas fa-check-circle',
                    'can'  => 'approve petty cash',
                ],
                [
                    'text' => 'Expense Account Settings',
                    'url'  => 'admin/pettycash/settings/expense-accounts',
                    'icon' => 'fas fa-sliders-h',
                    'can'  => 'manage accounts',
                ],
            ],
        ],

        // My Petty Cash - User View
        [
            'text' => 'My Petty Cash',
            'icon' => 'fas fa-wallet',
            'can'  => 'view own petty cash',
            'submenu' => [
                [
                    'text' => 'My Ledger',
                    'url'  => 'admin/pettycash/my-ledger',
                    'icon' => 'fas fa-book',
                    'can'  => 'view own petty cash',
                ],
                [
                    'text' => 'Add Expense',
                    'url'  => 'admin/pettycash/my-expense',
                    'icon' => 'fas fa-plus',
                    'can'  => 'add petty cash expense',
                ],
            ],
        ],

        // Journal Entries
        [
            'text' => 'Journal Entries',
            'icon' => 'fas fa-file-alt',
            'can'  => 'view journals',
            'submenu' => [
                [
                    'text' => 'View Entries',
                    'url'  => 'admin/journals',
                    'can'  => 'view journals',
                ],
                [
                    'text' => 'Create Entry',
                    'url'  => 'admin/journals/create',
                    'can'  => 'create journals',
                ],
                [
                    'text' => 'Record Expense',
                    'url'  => 'admin/journals/record-expense',
                    'can'  => 'create expenses',
                ],
            ],
        ],

        // Reports
        [
            'text' => 'Reports',
            'icon' => 'fas fa-chart-line',
            'can'  => 'view ledger',
            'submenu' => [
                [
                    'text' => 'General Ledger',
                    'url'  => 'admin/ledger',
                    'icon' => 'fas fa-book',
                    'can'  => 'view ledger',
                ],
            ],
        ],

        // Invoices
        [
            'text' => 'Invoices',
            'icon' => 'fas fa-file-invoice',
            'can'  => 'view invoices',
            'submenu' => [
                [
                    'text' => 'View Invoices',
                    'url'  => 'admin/invoices',
                    'can'  => 'view invoices',
                ],
                [
                    'text' => 'Create Invoice',
                    'url'  => 'admin/invoices/create',
                    'can'  => 'manage invoices',
                ],
                [
                    'text' => 'Add Invoice',
                    'url'  => 'admin/invoices/add-manual',
                    'can'  => 'manage invoices',
                ],
            ],
        ],

        // Invoice Items
        [
            'text' => 'Invoice Items',
            'icon' => 'fas fa-list',
            'can'  => 'manage invoices',
            'submenu' => [
                [
                    'text' => 'View Items',
                    'url'  => 'admin/invoice_items',
                ],
                [
                    'text' => 'Add Item',
                    'url'  => 'admin/invoice_items/create',
                ],
            ],
        ],

        // Customers
        [
            'text' => 'Customers',
            'icon' => 'fas fa-users',
            'can'  => 'manage customers',
            'submenu' => [
                [
                    'text' => 'View Customers',
                    'url'  => 'admin/customers',
                ],
                [
                    'text' => 'Add Customer',
                    'url'  => 'admin/customers/create',
                ],
                [
                    'text' => 'View Contacts',
                    'url'  => 'admin/customer_contacts',
                ],
                [
                    'text' => 'Add Contact',
                    'url'  => 'admin/customer_contacts/create',
                ],
            ],
        ],

        // Equipment
        [
            'text' => 'Equipment',
            'icon' => 'fas fa-tools',
            'can'  => 'manage equipment',
            'submenu' => [
                [
                    'text' => 'View Equipment',
                    'url'  => 'admin/equipment',
                ],
                [
                    'text' => 'Add Equipment',
                    'url'  => 'admin/equipment/create',
                ],
            ],
        ],

        // Vendors
        [
            'text' => 'Vendors',
            'icon' => 'fas fa-truck',
            'can'  => 'manage vendors',
            'submenu' => [
                [
                    'text' => 'View Vendors',
                    'url'  => 'admin/vendors',
                ],
                [
                    'text' => 'Create Vendor',
                    'url'  => 'admin/vendors/create',
                ],
            ],
        ],

        // Items
        [
            'text' => 'Items',
            'icon' => 'fas fa-box',
            'can'  => 'manage items',
            'submenu' => [
                [
                    'text' => 'View Items',
                    'url'  => 'admin/items',
                ],
                [
                    'text' => 'Add Item',
                    'url'  => 'admin/items/create',
                ],
            ],
        ],

        // Quotes
        [
            'text' => 'Quotes',
            'icon' => 'fas fa-file-alt',
            'can'  => 'manage quotes',
            'submenu' => [
                [
                    'text' => 'View Quotes',
                    'url'  => 'admin/quotes',
                ],
                [
                    'text' => 'Create Quote',
                    'url'  => 'admin/quotes/create',
                ],
            ],
        ],
];
