# Create folders
$folders = @(
  "resources/views/admin/invoices",
  "resources/views/admin/invoice_items",
  "resources/views/admin/customers",
  "resources/views/admin/customer_contacts",
  "resources/views/admin/items",
  "resources/views/admin/quotes"
)
foreach ($folder in $folders) {
  New-Item -ItemType Directory -Path $folder -Force | Out-Null
}

# Create files
$files = @(
  "invoices/index.blade.php",
  "invoices/create.blade.php",
  "invoices/edit.blade.php",
  "invoices/show.blade.php",

  "invoice_items/index.blade.php",
  "invoice_items/create.blade.php",
  "invoice_items/edit.blade.php",

  "customers/index.blade.php",
  "customers/create.blade.php",
  "customers/edit.blade.php",

  "customer_contacts/index.blade.php",
  "customer_contacts/create.blade.php",
  "customer_contacts/edit.blade.php",

  "items/index.blade.php",
  "items/create.blade.php",
  "items/edit.blade.php",

  "quotes/index.blade.php",
  "quotes/create.blade.php",
  "quotes/edit.blade.php"
)

foreach ($file in $files) {
  $path = "resources/views/admin/$file"
  New-Item -ItemType File -Path $path -Force | Out-Null
}
