<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoiceItemsTable extends Migration
{
    public function up()
    {
        Schema::create('invoice_items', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('invoice_id')->constrained()->onDelete('cascade');

            // item_code as a string foreign key to items.code
            $table->string('item_code', 50);
            $table->foreign('item_code')->references('code')->on('items')->onDelete('restrict');

            $table->text('description');
            $table->decimal('quantity', 10, 2);
            $table->decimal('unit_price', 12, 2);
            $table->integer('duration');
            $table->enum('duration_unit', ['day', 'week', 'month']);
            $table->decimal('line_total', 12, 2);
            $table->decimal('tax', 12, 2)->default(0);
            $table->decimal('line_total_with_tax', 12, 2);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('invoice_items');
    }
}

