<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('equipment', function (Blueprint $table) {
        $table->id();
        $table->string('eq_type');
        $table->string('eq_id')->unique();
        $table->string('capacity')->nullable();
        $table->text('description')->nullable();
        $table->string('make')->nullable();
        $table->string('model_no')->nullable();
        $table->string('ser_no')->nullable();
        $table->year('man_year')->nullable();
        $table->enum('status', ['ready', 'under_repair', 'major_damage', 'grounded', 'scrapped'])->default('ready');
        $table->text('remarks')->nullable();
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('equipment');
    }
};
