<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddJournalTrackingFieldsToInvoicesTable extends Migration
{
    public function up()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->boolean('is_recorded_in_journal')->default(false)->after('status');
            $table->decimal('amount_paid', 12, 2)->default(0)->after('total');
            $table->decimal('discount_given', 12, 2)->default(0)->after('amount_paid');
        });
    }

    public function down()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn([
                'is_recorded_in_journal',
                'amount_paid',
                'discount_given',
            ]);
        });
    }
}

