<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->string('employee_id')->unique();

            // Personal Information
            $table->string('full_name');
            $table->string('full_name_ar')->nullable();
            $table->string('photo')->nullable();
            $table->string('nationality');
            $table->enum('gender', ['male', 'female']);
            $table->date('date_of_birth');
            $table->enum('marital_status', ['single', 'married', 'divorced', 'widowed']);

            // Contact Details
            $table->string('email')->nullable();
            $table->string('phone');
            $table->string('phone_2')->nullable();
            $table->text('address')->nullable();

            // Emergency Contact
            $table->string('emergency_contact_name')->nullable();
            $table->string('emergency_contact_phone')->nullable();
            $table->string('emergency_contact_relationship')->nullable();

            // Employment Details
            $table->foreignId('department_id')->nullable()->constrained('departments')->onDelete('set null');
            $table->foreignId('designation_id')->nullable()->constrained('designations')->onDelete('set null');
            $table->foreignId('reporting_manager_id')->nullable()->constrained('users')->onDelete('set null');
            $table->enum('employment_type', ['full-time', 'part-time', 'contract', 'driver', 'technician']);
            $table->date('joining_date');
            $table->integer('probation_period_days')->default(90);
            $table->date('confirmation_date')->nullable();
            $table->enum('status', ['active', 'on_leave', 'suspended', 'terminated'])->default('active');
            $table->date('termination_date')->nullable();
            $table->text('termination_reason')->nullable();

            // Link to User Account (optional)
            $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('set null');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employees');
    }
};
