<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('petty_cash_expenses', function (Blueprint $table) {
            $table->boolean('vat_claimable')->nullable()->after('vat_amount')->comment('Whether the VAT paid can be claimed back');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('petty_cash_expenses', function (Blueprint $table) {
            $table->dropColumn('vat_claimable');
        });
    }
};
