<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run(): void
    {
        // (Re)create permissions
        $permissions = [
            // Journals
            'journals.view',
            'journals.create',
            'journals.edit',
            'journals.delete',

            // Invoices (sample)
            'invoices.view',
            'invoices.create',
            'invoices.edit',
            'invoices.delete',

            // Accounts (sample)
            'accounts.view',
            'accounts.create',
            'accounts.edit',
            'accounts.delete',
        ];

        foreach ($permissions as $p) {
            Permission::findOrCreate($p, 'web');
        }

        // Roles
        $admin = Role::findOrCreate('admin', 'web');
        $user  = Role::findOrCreate('user', 'web');

        // Admin gets everything
        $admin->givePermissionTo(Permission::all());

        // User gets limited abilities (adjust as needed)
        $user->givePermissionTo([
            'journals.view',
            'journals.create',
            'invoices.view',
        ]);

        // Attach roles to existing users (adjust IDs / emails as needed)
        if ($adminUser = User::where('email', 'admin@example.com')->first()) {
            $adminUser->assignRole('admin');
        }

        if ($normalUser = User::where('email', 'user@example.com')->first()) {
            $normalUser->assignRole('user');
        }
    }
}
