<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // Create roles if they don't exist
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        $userRole = Role::firstOrCreate(['name' => 'user']);

        // Create admin user
        $admin = User::create([
            'name' => 'Noor Admin',
            'email' => 'admin@rms.com',
            'password' => Hash::make('password'),
        ]);
        $admin->assignRole($adminRole);

        // Create regular user
        $user = User::create([
            'name' => 'Ali User',
            'email' => 'user@rms.com',
            'password' => Hash::make('password'),
        ]);
        $user->assignRole($userRole);
    }
}

