<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class VatAccountsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $accounts = [
            [
                'code' => '2101',
                'name' => 'VAT Payable',
                'type' => 'liability',
                'is_posting' => 1,
                'parent_id' => null,
                'user_id' => null,
                'show_in_petty_cash' => false,
            ],
            [
                'code' => '1201',
                'name' => 'VAT Receivable',
                'type' => 'asset',
                'is_posting' => 1,
                'parent_id' => null,
                'user_id' => null,
                'show_in_petty_cash' => false,
            ],
        ];

        foreach ($accounts as $account) {
            \App\Models\Account::firstOrCreate(
                ['code' => $account['code']],
                $account
            );
        }

        $this->command->info('VAT accounts created successfully!');
    }
}
