@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Create Customer Contact</h2>

    <form action="{{ route('customer_contacts.store') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label for="customer_id">Customer</label>
            <select name="customer_id" class="form-control" required>
                <option value="">Select Customer</option>
                @foreach($customers as $customer)
                    <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>
                        {{ $customer->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="name">Contact Name</label>
            <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
        </div>

        <div class="mb-3">
            <label for="designation">Designation</label>
            <input type="text" name="designation" class="form-control" value="{{ old('designation') }}">
        </div>

        <div class="mb-3">
            <label for="email">Email</label>
            <input type="email" name="email" class="form-control" value="{{ old('email') }}">
        </div>

        <div class="mb-3">
            <label for="mobile1">Mobile 1</label>
            <input type="text" name="mobile1" class="form-control" value="{{ old('mobile1') }}">
        </div>

        <div class="mb-3">
            <label for="mobile2">Mobile 2</label>
            <input type="text" name="mobile2" class="form-control" value="{{ old('mobile2') }}">
        </div>

        <div class="mb-3">
            <label for="mobile3">Mobile 3</label>
            <input type="text" name="mobile3" class="form-control" value="{{ old('mobile3') }}">
        </div>

        <button type="submit" class="btn btn-success">Create Contact</button>
    </form>
</div>
@endsection
