@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Equipment List</h2>
    <a href="{{ route('equipment.create') }}" class="btn btn-primary mb-3">Add Equipment</a>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Type</th>
                <th>Equipment ID</th>
                <th>Capacity</th>
                <th>Description</th>
                <th>Make</th>
                <th>Model No</th>
                <th>Serial No</th>
                <th>Year</th>
                <th>Status</th>
                <th>Remarks</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($equipment as $eq)
                <tr>
                    <td>{{ $eq->id }}</td>
                    <td>{{ $eq->eq_type }}</td>
                    <td>{{ $eq->eq_id }}</td>
                    <td>{{ $eq->capacity }}</td>
                    <td>{{ $eq->description }}</td>
                    <td>{{ $eq->make }}</td>
                    <td>{{ $eq->model_no }}</td>
                    <td>{{ $eq->ser_no }}</td>
                    <td>{{ $eq->man_year }}</td>
                    <td>{{ ucfirst($eq->status) }}</td>
                    <td>{{ $eq->remarks }}</td>
                    <td>
                        <a href="{{ route('equipment.edit', $eq->id) }}" class="btn btn-sm btn-warning">Edit</a>
                        <form action="{{ route('equipment.destroy', $eq->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this equipment?')">
                            @csrf @method('DELETE')
                            <button class="btn btn-sm btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
