<div class="mb-3">
    <label for="eq_type">Equipment Type</label>
    <input type="text" name="eq_type" class="form-control" value="{{ old('eq_type', $equipment->eq_type ?? '') }}" required>
</div>

<div class="mb-3">
    <label for="eq_id">Equipment ID</label>
    <input type="text" name="eq_id" class="form-control" value="{{ old('eq_id', $equipment->eq_id ?? '') }}" required>
</div>

<div class="mb-3">
    <label for="capacity">Capacity</label>
    <input type="text" name="capacity" class="form-control" value="{{ old('capacity', $equipment->capacity ?? '') }}">
</div>

<div class="mb-3">
    <label for="description">Description</label>
    <textarea name="description" class="form-control">{{ old('description', $equipment->description ?? '') }}</textarea>
</div>

<div class="mb-3">
    <label for="make">Make</label>
    <input type="text" name="make" class="form-control" value="{{ old('make', $equipment->make ?? '') }}">
</div>

<div class="mb-3">
    <label for="model_no">Model No</label>
    <input type="text" name="model_no" class="form-control" value="{{ old('model_no', $equipment->model_no ?? '') }}">
</div>

<div class="mb-3">
    <label for="ser_no">Serial No</label>
    <input type="text" name="ser_no" class="form-control" value="{{ old('ser_no', $equipment->ser_no ?? '') }}">
</div>

<div class="mb-3">
    <label for="man_year">Manufacturing Year</label>
    <input type="number" name="man_year" class="form-control" value="{{ old('man_year', $equipment->man_year ?? '') }}">
</div>

<div class="mb-3">
    <label for="status">Status</label>
    <select name="status" class="form-select" required>
        @foreach (['ready', 'under_repair', 'major_damage', 'grounded', 'scrapped'] as $status)
            <option value="{{ $status }}" @selected(old('status', $equipment->status ?? '') == $status)>
                {{ ucfirst(str_replace('_', ' ', $status)) }}
            </option>
        @endforeach
    </select>
</div>

<div class="mb-3">
    <label for="remarks">Remarks</label>
    <textarea name="remarks" class="form-control">{{ old('remarks', $equipment->remarks ?? '') }}</textarea>
</div>
