@extends('adminlte::page')

@section('title', 'Attendance Records')

@section('content_header')
    <h1>Attendance Records</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Attendance Records</h3>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.hr.attendance.index') }}" class="mb-3">
                <div class="row">
                    <div class="col-md-3">
                        <select name="month" class="form-control" onchange="this.form.submit()">
                            @foreach($months as $monthValue => $monthLabel)
                                <option value="{{ $monthValue }}" {{ request('month', now()->format('Y-m')) == $monthValue ? 'selected' : '' }}>
                                    {{ $monthLabel }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </form>

            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="info-box">
                        <span class="info-box-icon bg-info"><i class="fas fa-calendar-check"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Days Worked</span>
                            <span class="info-box-number">{{ $summary['days_worked'] }}</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="info-box">
                        <span class="info-box-icon bg-warning"><i class="fas fa-calendar-times"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Off Days</span>
                            <span class="info-box-number">{{ $summary['off_days'] }}</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="info-box">
                        <span class="info-box-icon {{ $summary['total_ot'] >= 0 ? 'bg-success' : 'bg-danger' }}">
                            <i class="fas fa-clock"></i>
                        </span>
                        <div class="info-box-content">
                            <span class="info-box-text">Total OT</span>
                            <span class="info-box-number">
                                {{ $summary['total_ot'] >= 0 ? '+' : '' }}{{ number_format($summary['total_ot'], 2) }} hrs
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Desktop View -->
            <div class="d-none d-md-block">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Check In</th>
                            <th>Check Out</th>
                            <th>Total Hours</th>
                            <th>OT</th>
                            <th>Status</th>
                            <th>Approved By</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($attendances as $attendance)
                            <tr>
                                <td>{{ $attendance->date->format('d M Y') }}</td>
                                <td>{{ $attendance->check_in ? \Carbon\Carbon::parse($attendance->check_in)->format('h:i A') : 'N/A' }}</td>
                                <td>{{ $attendance->check_out ? \Carbon\Carbon::parse($attendance->check_out)->format('h:i A') : 'N/A' }}</td>
                                <td>{{ $attendance->total_hours ? number_format($attendance->total_hours, 2) . ' hrs' : 'N/A' }}</td>
                                <td>
                                    @if($attendance->total_hours)
                                        @php
                                            $overtime = $attendance->total_hours - 9;
                                            $otClass = $overtime >= 0 ? 'text-success' : 'text-danger';
                                            $otSign = $overtime >= 0 ? '+' : '';
                                        @endphp
                                        <span class="{{ $otClass }} font-weight-bold">
                                            {{ $otSign }}{{ number_format($overtime, 2) }} hrs
                                        </span>
                                    @else
                                        <span class="text-muted">N/A</span>
                                    @endif
                                </td>
                                <td>
                                    @switch($attendance->status)
                                        @case('present')
                                            <span class="badge badge-success">Present</span>
                                            @break
                                        @case('absent')
                                            <span class="badge badge-danger">Absent</span>
                                            @break
                                        @case('late')
                                            <span class="badge badge-warning">Late</span>
                                            @break
                                        @case('half_day')
                                            <span class="badge badge-info">Half Day</span>
                                            @break
                                        @case('on_leave')
                                            <span class="badge badge-secondary">On Leave</span>
                                            @break
                                    @endswitch
                                </td>
                                <td>
                                    @if($attendance->approved_by)
                                        <span class="badge badge-success">
                                            <i class="fas fa-check"></i> {{ $attendance->approver->name }}
                                        </span>
                                    @else
                                        <span class="badge badge-warning">Pending</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">No attendance records found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Mobile View -->
            <div class="d-md-none">
                @forelse($attendances as $attendance)
                    <div class="card mb-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="mb-0">{{ $attendance->date->format('d M Y') }}</h5>
                                @if($attendance->approved_by)
                                    <span class="badge badge-success">
                                        <i class="fas fa-check"></i> Approved
                                    </span>
                                @else
                                    <span class="badge badge-warning">Pending</span>
                                @endif
                            </div>

                            <div class="row mb-2">
                                <div class="col-6">
                                    <small class="text-muted">Check In</small>
                                    <div class="font-weight-bold">
                                        {{ $attendance->check_in ? \Carbon\Carbon::parse($attendance->check_in)->format('h:i A') : 'N/A' }}
                                    </div>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">Check Out</small>
                                    <div class="font-weight-bold">
                                        {{ $attendance->check_out ? \Carbon\Carbon::parse($attendance->check_out)->format('h:i A') : 'N/A' }}
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-6">
                                    <small class="text-muted">Total Hours</small>
                                    <div class="font-weight-bold">
                                        {{ $attendance->total_hours ? number_format($attendance->total_hours, 2) . ' hrs' : 'N/A' }}
                                    </div>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">OT</small>
                                    <div>
                                        @if($attendance->total_hours)
                                            @php
                                                $overtime = $attendance->total_hours - 9;
                                                $otClass = $overtime >= 0 ? 'text-success' : 'text-danger';
                                                $otSign = $overtime >= 0 ? '+' : '';
                                            @endphp
                                            <span class="{{ $otClass }} font-weight-bold">
                                                {{ $otSign }}{{ number_format($overtime, 2) }} hrs
                                            </span>
                                        @else
                                            <span class="text-muted">N/A</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> No attendance records found.
                    </div>
                @endforelse
            </div>
        </div>
        <div class="card-footer">
            {{ $attendances->links() }}
        </div>
    </div>
@stop
