@extends('adminlte::page')

@section('title', 'Designations')

@section('content_header')
    <h1>Designations</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Designations</h3>
            <div class="card-tools">
                @can('manage designations')
                    <a href="{{ route('admin.hr.designations.create') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add Designation
                    </a>
                @endcan
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Name (Arabic)</th>
                        <th>Description</th>
                        <th>Employees</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($designations as $designation)
                        <tr>
                            <td>{{ $designation->name }}</td>
                            <td>{{ $designation->name_ar ?? 'N/A' }}</td>
                            <td>{{ $designation->description ? Str::limit($designation->description, 50) : 'N/A' }}</td>
                            <td>
                                <span class="badge badge-info">{{ $designation->employees_count }}</span>
                            </td>
                            <td>
                                @if($designation->is_active)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-secondary">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.hr.designations.show', $designation) }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i>
                                </a>
                                @can('manage designations')
                                    <a href="{{ route('admin.hr.designations.edit', $designation) }}" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('admin.hr.designations.destroy', $designation) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                @endcan
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center">No designations found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="card-footer">
            {{ $designations->links() }}
        </div>
    </div>
@stop
