@extends('adminlte::page')

@section('title', 'Designation Details')

@section('content_header')
    <h1>Designation: {{ $designation->name }}</h1>
@stop

@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Designation Information</h3>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <th>Name:</th>
                            <td>{{ $designation->name }}</td>
                        </tr>
                        @if($designation->name_ar)
                            <tr>
                                <th>Name (Arabic):</th>
                                <td>{{ $designation->name_ar }}</td>
                            </tr>
                        @endif
                        <tr>
                            <th>Status:</th>
                            <td>
                                @if($designation->is_active)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-secondary">Inactive</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Total Employees:</th>
                            <td><span class="badge badge-info">{{ $designation->employees->count() }}</span></td>
                        </tr>
                    </table>

                    @if($designation->description)
                        <div class="mt-3">
                            <h5>Description</h5>
                            <p>{{ $designation->description }}</p>
                        </div>
                    @endif

                    <div class="mt-3">
                        @can('manage designations')
                            <a href="{{ route('admin.hr.designations.edit', $designation) }}" class="btn btn-primary btn-block">
                                <i class="fas fa-edit"></i> Edit Designation
                            </a>
                        @endcan
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Employees with this Designation</h3>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Employee ID</th>
                                <th>Name</th>
                                <th>Department</th>
                                <th>Phone</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($designation->employees as $employee)
                                <tr>
                                    <td>{{ $employee->employee_id }}</td>
                                    <td>
                                        <a href="{{ route('admin.hr.employees.show', $employee) }}">
                                            {{ $employee->full_name }}
                                        </a>
                                    </td>
                                    <td>{{ $employee->department->name ?? 'N/A' }}</td>
                                    <td>{{ $employee->phone }}</td>
                                    <td>
                                        @switch($employee->status)
                                            @case('active')
                                                <span class="badge badge-success">Active</span>
                                                @break
                                            @case('on_leave')
                                                <span class="badge badge-warning">On Leave</span>
                                                @break
                                            @case('suspended')
                                                <span class="badge badge-danger">Suspended</span>
                                                @break
                                            @case('terminated')
                                                <span class="badge badge-dark">Terminated</span>
                                                @break
                                        @endswitch
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">No employees with this designation.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@stop
