@extends('adminlte::page')

@section('title', 'Edit Employee')

@section('content_header')
    <h1>Edit Employee: {{ $employee->full_name }}</h1>
@stop

@section('content')
    <div class="card">
        <form action="{{ route('admin.hr.employees.update', $employee) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h5>Personal Information</h5>

                        <div class="form-group">
                            <label for="full_name">Full Name <span class="text-danger">*</span></label>
                            <input type="text" name="full_name" id="full_name" class="form-control @error('full_name') is-invalid @enderror" value="{{ old('full_name', $employee->full_name) }}" required>
                            @error('full_name')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="full_name_ar">Full Name (Arabic)</label>
                            <input type="text" name="full_name_ar" id="full_name_ar" class="form-control @error('full_name_ar') is-invalid @enderror" value="{{ old('full_name_ar', $employee->full_name_ar) }}">
                            @error('full_name_ar')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="photo">Photo</label>
                            @if($employee->photo)
                                <div class="mb-2">
                                    <img src="{{ asset('storage/' . $employee->photo) }}" alt="{{ $employee->full_name }}" class="img-thumbnail" style="max-width: 150px;">
                                </div>
                            @endif
                            <input type="file" name="photo" id="photo" class="form-control-file @error('photo') is-invalid @enderror" accept="image/*">
                            @error('photo')<span class="invalid-feedback">{{ $message }}</span>@enderror
                            <small class="form-text text-muted">Leave blank to keep current photo.</small>
                        </div>

                        <div class="form-group">
                            <label for="nationality">Nationality <span class="text-danger">*</span></label>
                            <input type="text" name="nationality" id="nationality" class="form-control @error('nationality') is-invalid @enderror" value="{{ old('nationality', $employee->nationality) }}" required>
                            @error('nationality')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="gender">Gender <span class="text-danger">*</span></label>
                            <select name="gender" id="gender" class="form-control @error('gender') is-invalid @enderror" required>
                                <option value="">Select Gender</option>
                                <option value="male" {{ old('gender', $employee->gender) == 'male' ? 'selected' : '' }}>Male</option>
                                <option value="female" {{ old('gender', $employee->gender) == 'female' ? 'selected' : '' }}>Female</option>
                            </select>
                            @error('gender')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="date_of_birth">Date of Birth <span class="text-danger">*</span></label>
                            <input type="date" name="date_of_birth" id="date_of_birth" class="form-control @error('date_of_birth') is-invalid @enderror" value="{{ old('date_of_birth', $employee->date_of_birth->format('Y-m-d')) }}" required>
                            @error('date_of_birth')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="marital_status">Marital Status <span class="text-danger">*</span></label>
                            <select name="marital_status" id="marital_status" class="form-control @error('marital_status') is-invalid @enderror" required>
                                <option value="">Select Status</option>
                                <option value="single" {{ old('marital_status', $employee->marital_status) == 'single' ? 'selected' : '' }}>Single</option>
                                <option value="married" {{ old('marital_status', $employee->marital_status) == 'married' ? 'selected' : '' }}>Married</option>
                                <option value="divorced" {{ old('marital_status', $employee->marital_status) == 'divorced' ? 'selected' : '' }}>Divorced</option>
                                <option value="widowed" {{ old('marital_status', $employee->marital_status) == 'widowed' ? 'selected' : '' }}>Widowed</option>
                            </select>
                            @error('marital_status')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <h5 class="mt-4">Contact Details</h5>

                        <div class="form-group">
                            <label for="email">Email</label>
                            <input type="email" name="email" id="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $employee->email) }}">
                            @error('email')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="phone">Phone <span class="text-danger">*</span></label>
                            <input type="text" name="phone" id="phone" class="form-control @error('phone') is-invalid @enderror" value="{{ old('phone', $employee->phone) }}" required>
                            @error('phone')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="phone_2">Phone 2</label>
                            <input type="text" name="phone_2" id="phone_2" class="form-control @error('phone_2') is-invalid @enderror" value="{{ old('phone_2', $employee->phone_2) }}">
                            @error('phone_2')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="address">Address</label>
                            <textarea name="address" id="address" class="form-control @error('address') is-invalid @enderror" rows="3">{{ old('address', $employee->address) }}</textarea>
                            @error('address')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <h5>Emergency Contact</h5>

                        <div class="form-group">
                            <label for="emergency_contact_name">Emergency Contact Name</label>
                            <input type="text" name="emergency_contact_name" id="emergency_contact_name" class="form-control @error('emergency_contact_name') is-invalid @enderror" value="{{ old('emergency_contact_name', $employee->emergency_contact_name) }}">
                            @error('emergency_contact_name')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="emergency_contact_phone">Emergency Contact Phone</label>
                            <input type="text" name="emergency_contact_phone" id="emergency_contact_phone" class="form-control @error('emergency_contact_phone') is-invalid @enderror" value="{{ old('emergency_contact_phone', $employee->emergency_contact_phone) }}">
                            @error('emergency_contact_phone')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="emergency_contact_relationship">Relationship</label>
                            <input type="text" name="emergency_contact_relationship" id="emergency_contact_relationship" class="form-control @error('emergency_contact_relationship') is-invalid @enderror" value="{{ old('emergency_contact_relationship', $employee->emergency_contact_relationship) }}">
                            @error('emergency_contact_relationship')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <h5 class="mt-4">Employment Details</h5>

                        <div class="form-group">
                            <label for="department_id">Department</label>
                            <select name="department_id" id="department_id" class="form-control @error('department_id') is-invalid @enderror">
                                <option value="">Select Department</option>
                                @foreach($departments as $department)
                                    <option value="{{ $department->id }}" {{ old('department_id', $employee->department_id) == $department->id ? 'selected' : '' }}>
                                        {{ $department->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('department_id')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="designation_id">Designation</label>
                            <select name="designation_id" id="designation_id" class="form-control @error('designation_id') is-invalid @enderror">
                                <option value="">Select Designation</option>
                                @foreach($designations as $designation)
                                    <option value="{{ $designation->id }}" {{ old('designation_id', $employee->designation_id) == $designation->id ? 'selected' : '' }}>
                                        {{ $designation->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('designation_id')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="reporting_manager_id">Reporting Manager</label>
                            <select name="reporting_manager_id" id="reporting_manager_id" class="form-control @error('reporting_manager_id') is-invalid @enderror">
                                <option value="">Select Manager</option>
                                @foreach($managers as $manager)
                                    <option value="{{ $manager->id }}" {{ old('reporting_manager_id', $employee->reporting_manager_id) == $manager->id ? 'selected' : '' }}>
                                        {{ $manager->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('reporting_manager_id')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="employment_type">Employment Type <span class="text-danger">*</span></label>
                            <select name="employment_type" id="employment_type" class="form-control @error('employment_type') is-invalid @enderror" required>
                                <option value="">Select Type</option>
                                <option value="full-time" {{ old('employment_type', $employee->employment_type) == 'full-time' ? 'selected' : '' }}>Full-time</option>
                                <option value="part-time" {{ old('employment_type', $employee->employment_type) == 'part-time' ? 'selected' : '' }}>Part-time</option>
                                <option value="contract" {{ old('employment_type', $employee->employment_type) == 'contract' ? 'selected' : '' }}>Contract</option>
                                <option value="driver" {{ old('employment_type', $employee->employment_type) == 'driver' ? 'selected' : '' }}>Driver</option>
                                <option value="technician" {{ old('employment_type', $employee->employment_type) == 'technician' ? 'selected' : '' }}>Technician</option>
                            </select>
                            @error('employment_type')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="joining_date">Joining Date <span class="text-danger">*</span></label>
                            <input type="date" name="joining_date" id="joining_date" class="form-control @error('joining_date') is-invalid @enderror" value="{{ old('joining_date', $employee->joining_date->format('Y-m-d')) }}" required>
                            @error('joining_date')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="probation_period_days">Probation Period (Days)</label>
                            <input type="number" name="probation_period_days" id="probation_period_days" class="form-control @error('probation_period_days') is-invalid @enderror" value="{{ old('probation_period_days', $employee->probation_period_days) }}">
                            @error('probation_period_days')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="confirmation_date">Confirmation Date</label>
                            <input type="date" name="confirmation_date" id="confirmation_date" class="form-control @error('confirmation_date') is-invalid @enderror" value="{{ old('confirmation_date', $employee->confirmation_date?->format('Y-m-d')) }}">
                            @error('confirmation_date')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="status">Status <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                <option value="active" {{ old('status', $employee->status) == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="on_leave" {{ old('status', $employee->status) == 'on_leave' ? 'selected' : '' }}>On Leave</option>
                                <option value="suspended" {{ old('status', $employee->status) == 'suspended' ? 'selected' : '' }}>Suspended</option>
                                <option value="terminated" {{ old('status', $employee->status) == 'terminated' ? 'selected' : '' }}>Terminated</option>
                            </select>
                            @error('status')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group" id="termination_date_group" style="display: {{ old('status', $employee->status) == 'terminated' ? 'block' : 'none' }};">
                            <label for="termination_date">Termination Date</label>
                            <input type="date" name="termination_date" id="termination_date" class="form-control @error('termination_date') is-invalid @enderror" value="{{ old('termination_date', $employee->termination_date?->format('Y-m-d')) }}">
                            @error('termination_date')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group" id="termination_reason_group" style="display: {{ old('status', $employee->status) == 'terminated' ? 'block' : 'none' }};">
                            <label for="termination_reason">Termination Reason</label>
                            <textarea name="termination_reason" id="termination_reason" class="form-control @error('termination_reason') is-invalid @enderror" rows="3">{{ old('termination_reason', $employee->termination_reason) }}</textarea>
                            @error('termination_reason')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Update Employee</button>
                <a href="{{ route('admin.hr.employees.index') }}" class="btn btn-default">Cancel</a>
            </div>
        </form>
    </div>
@stop

@section('js')
<script>
    document.getElementById('status').addEventListener('change', function() {
        const terminationDateGroup = document.getElementById('termination_date_group');
        const terminationReasonGroup = document.getElementById('termination_reason_group');

        if (this.value === 'terminated') {
            terminationDateGroup.style.display = 'block';
            terminationReasonGroup.style.display = 'block';
        } else {
            terminationDateGroup.style.display = 'none';
            terminationReasonGroup.style.display = 'none';
        }
    });
</script>
@stop
