@extends('adminlte::page')

@section('title', 'Employees')

@section('content_header')
    <h1>Employees</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Employees</h3>
            <div class="card-tools">
                @can('create employees')
                    <a href="{{ route('admin.hr.employees.create') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add Employee
                    </a>
                @endcan
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Employee ID</th>
                        <th>Photo</th>
                        <th>Name</th>
                        <th>Department</th>
                        <th>Designation</th>
                        <th>Phone</th>
                        <th>Status</th>
                        <th>User Account</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($employees as $employee)
                        <tr>
                            <td>{{ $employee->employee_id }}</td>
                            <td>
                                @if($employee->photo)
                                    <img src="{{ asset('storage/' . $employee->photo) }}" alt="{{ $employee->full_name }}" class="img-thumbnail" style="width: 50px; height: 50px;">
                                @else
                                    <span class="text-muted">No photo</span>
                                @endif
                            </td>
                            <td>{{ $employee->full_name }}</td>
                            <td>{{ $employee->department->name ?? 'N/A' }}</td>
                            <td>{{ $employee->designation->name ?? 'N/A' }}</td>
                            <td>{{ $employee->phone }}</td>
                            <td>
                                @switch($employee->status)
                                    @case('active')
                                        <span class="badge badge-success">Active</span>
                                        @break
                                    @case('on_leave')
                                        <span class="badge badge-warning">On Leave</span>
                                        @break
                                    @case('suspended')
                                        <span class="badge badge-danger">Suspended</span>
                                        @break
                                    @case('terminated')
                                        <span class="badge badge-dark">Terminated</span>
                                        @break
                                @endswitch
                            </td>
                            <td class="text-center">
                                @if($employee->user_id)
                                    <span class="badge badge-success" title="Has user account">
                                        <i class="fas fa-check"></i> Yes
                                    </span>
                                @else
                                    <span class="badge badge-secondary" title="No user account">
                                        <i class="fas fa-times"></i> No
                                    </span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.hr.employees.show', $employee) }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i>
                                </a>
                                @can('edit employees')
                                    <a href="{{ route('admin.hr.employees.edit', $employee) }}" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                @endcan
                                @can('delete employees')
                                    <form action="{{ route('admin.hr.employees.destroy', $employee) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                @endcan
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center">No employees found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="card-footer">
            {{ $employees->links() }}
        </div>
    </div>
@stop
