@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Invoice Items</h2>
    <a href="{{ route('invoice_items.create') }}" class="btn btn-primary mb-3">Create Invoice Item</a>
    <table class="table">
        <thead>
            <tr>
                <th>Item Code</th>
                <th>Description</th>
                <th>Quantity</th>
                <th>Unit Price</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoiceItems as $item)
                <tr>
                    <td>{{ $item->item_code }}</td>
                    <td>{{ $item->description }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>{{ $item->unit_price }}</td>
                    <td>
                        <a href="{{ route('invoice_items.edit', $item->id) }}" class="btn btn-warning">Edit</a>
                        <form action="{{ route('invoice_items.destroy', $item->id) }}" method="POST" style="display:inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
