@extends('adminlte::page')

@section('title', 'Add Manual Invoice')

@section('content')
<div class="container">
    <h2>Add Manual Invoice</h2>

    <form action="{{ route('admin.invoices.add-manual.store') }}" method="POST">
        @csrf

        <div class="row">
            <div class="col-md-4 mb-3">
                <label>Invoice Number</label>
                <input type="text" name="invoice_number" class="form-control" value="{{ old('invoice_number', $nextInvoiceNumber ?? '') }}" required>
            </div>
            <div class="col-md-4 mb-3">
                <label>Invoice Date</label>
                <input type="text" name="invoice_date" class="form-control datepicker" readonly required>
            </div>
            <div class="col-md-4 mb-3">
                <label>Customer</label>
                <select name="customer_id" class="form-control" required>
                    @foreach($customers as $customer)
                        <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>
                            {{ $customer->name }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label>Subject</label>
                <input type="text" name="subject" class="form-control" value="{{ old('subject') }}" required>
            </div>
            <div class="col-md-6 mb-3">
                <label>Project Site</label>
                <input type="text" name="project_site" class="form-control" value="{{ old('project_site') }}">
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label>Rental Start</label>
                <input type="text" name="rental_start" class="form-control datepicker" value="{{ old('rental_start') }}" readonly>
            </div>
            <div class="col-md-6 mb-3">
                <label>Rental End</label>
                <input type="text" name="rental_end" class="form-control datepicker" value="{{ old('rental_end') }}" readonly>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label>Quote</label>
                <select name="quote_id" class="form-control">
                    <option value="">-- Optional --</option>
                    @foreach($quotes as $quote)
                        <option value="{{ $quote->id }}" {{ old('quote_id') == $quote->id ? 'selected' : '' }}>
                            {{ $quote->quote_number }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6 mb-3">
                <label>Status</label>
                <select name="status" class="form-control">
                    @php $statuses = ['created', 'submitted', 'partially_paid', 'paid', 'cancelled']; @endphp
                    @foreach ($statuses as $status)
                        <option value="{{ $status }}" {{ old('status') === $status ? 'selected' : '' }}>
                            {{ ucfirst(str_replace('_', ' ', $status)) }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label>Subtotal</label>
                <input type="number" name="subtotal" class="form-control" step="0.01" value="{{ old('subtotal') }}">
            </div>
            <div class="col-md-3 mb-3">
                <label>Discount</label>
                <input type="number" name="discount" class="form-control" step="0.01" value="{{ old('discount', 0) }}">
            </div>
            <div class="col-md-3 mb-3">
                <label>Taxable Total</label>
                <input type="number" name="taxable_total" class="form-control" step="0.01" value="{{ old('taxable_total') }}">
            </div>
            <div class="col-md-3 mb-3">
                <label>VAT (5%)</label>
                <input type="number" name="tax_total" class="form-control" step="0.01" value="{{ old('tax_total') }}">
            </div>
        </div>

        <div class="mb-3">
            <label>Total</label>
            <input type="number" name="total" class="form-control" step="0.01" value="{{ old('total') }}" required>
        </div>

        <button type="submit" class="btn btn-success">Add Invoice</button>
    </form>
</div>
@endsection

@section('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
@endsection

@section('js')
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
    $(function () {
        $('.datepicker').datepicker({
            dateFormat: 'yy-mm-dd',
            changeMonth: true,
            changeYear: true
        });

        $('[name="taxable_total"]').on('input', function () {
            const taxableTotal = parseFloat($(this).val()) || 0;
            const taxTotal = (taxableTotal * 0.05).toFixed(2);
            const total = (taxableTotal + parseFloat(taxTotal)).toFixed(2);

            $('[name="tax_total"]').val(taxTotal);
            $('[name="total"]').val(total);
        });
    });
</script>
@endsection
