@extends('adminlte::page')

@section('title', 'Receive Payment')

@section('content')
<div class="container">
    <h2>Receive Payment for Invoice #{{ $invoice->invoice_number }}</h2>

    {{-- Invoice Summary --}}
    <div class="card mb-4">
        <div class="card-header">Invoice Details</div>
        <div class="card-body">
            <p><strong>Customer:</strong> {{ $invoice->customer->name }}</p>
            <p><strong>Date:</strong> {{ $invoice->invoice_date }}</p>
            <p><strong>Total:</strong> {{ number_format($invoice->total, 2) }}</p>
            <p><strong>Paid:</strong> {{ number_format($invoice->amount_paid, 2) }}</p>
            <p><strong>Discount:</strong> {{ number_format($invoice->discount_given, 2) }}</p>
            <p><strong>Outstanding:</strong>
                <strong id="outstandingValue" class="text-danger">
                    {{ number_format($invoice->total - $invoice->amount_paid - $invoice->discount_given, 2) }}
                </strong>
            </p>
        </div>
    </div>

    {{-- Previous Journal Entries --}}
    <div class="card mb-4">
        <div class="card-header">Previous Journal Entries</div>
        <div class="card-body p-0">
            @php $journals = $invoice->journalEntries; @endphp
            @if($journals->isEmpty())
                <p class="p-3">No journal entries found.</p>
            @else
                <table class="table table-bordered mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Date</th>
                            <th>Account</th>
                            <th>AC Code</th>
                            <th>Debit</th>
                            <th>Credit</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($journals as $journal)
                            @foreach($journal->transactions as $i => $t)
                                <tr>
                                    @if($i === 0)
                                        <td rowspan="{{ $journal->transactions->count() + 1 }}">
                                            {{ \Carbon\Carbon::parse($journal->date)->format('d/m/Y') }}
                                        </td>
                                    @endif
                                    <td>{{ $t->account->name }}</td>
                                    <td>{{ $t->account->code ?? 'N/A' }}</td>
                                    <td>{{ $t->debit > 0 ? number_format($t->debit, 2) : '' }}</td>
                                    <td>{{ $t->credit > 0 ? number_format($t->credit, 2) : '' }}</td>
                                </tr>
                            @endforeach
                            <tr class="table-secondary">
                                <td colspan="5"><em>{{ $journal->description }}</em></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>
    </div>

    {{-- Payment Form --}}
    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>There were some errors:</strong>
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.invoices.storePayment', $invoice->id) }}" method="POST" id="paymentForm">
        @csrf

        <div class="card mb-3">
            <div class="card-header">Receive Payment</div>
            <div class="card-body">

                {{-- Meta --}}
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label>Payment Date</label>
                        <input type="date" name="date" class="form-control" value="{{ now()->toDateString() }}" required>
                    </div>
                    <div class="col-md-8">
                        <label>Description</label>
                        <input type="text" name="description" class="form-control"
                               value="Payment received for Invoice #{{ $invoice->invoice_number }}" required>
                    </div>
                </div>

                <div id="debitRows">
                    <div class="debit-row row mb-2">
                        <div class="col-md-5">
                            <label>Debit Account</label>
                            <select name="transactions[0][debit_account_id]" class="form-control" required>
                                <option value="">-- Select Account --</option>
                                @foreach($cashAccounts as $acc)
                                    <option value="{{ $acc->id }}">{{ $acc->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-5">
                            <label>Amount</label>
                            <input type="number" name="transactions[0][debit]" class="form-control debit-amount"
                                   step="0.01" required>
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button type="button" class="btn btn-sm btn-success add-row">+</button>
                        </div>
                    </div>
                </div>

                <hr>

                {{-- Credit Side --}}
                <div class="row mb-2">
                    <div class="col-md-5">
                        <label>Credit Account</label>
                        
                        <input type="text" class="form-control" value="{{ $receivableAccount->name }}" readonly>

                        <input type="hidden" name="credit_account_id" value="{{ $receivableAccount->id }}">

                    </div>
                    <div class="col-md-5">
                        <label>Credit Amount</label>
                        
                  
                        <input type="number" name="credit_amount" class="form-control" step="0.01" readonly id="creditAmount">
                        
                        <div id="amountError" class="text-danger mt-1" style="display:none;"></div>
                    </div>
                </div>

                <button type="submit" class="btn btn-success mt-3" id="submitBtn">Post Payment</button>
            </div>
        </div>
    </form>
</div>
@endsection

@section('js')
<script>
    let rowCount = 1;
    const maxAmount = parseFloat("{{ $invoice->total - $invoice->amount_paid - $invoice->discount_given }}");

    function updateCreditAmount() {
        let total = 0;
        document.querySelectorAll('.debit-amount').forEach(input => {
            total += parseFloat(input.value) || 0;
        });

        const creditInput = document.getElementById('creditAmount');
        const errorDiv = document.getElementById('amountError');
        const submitBtn = document.getElementById('submitBtn');

        creditInput.value = total.toFixed(2);

        if (total > maxAmount) {
            errorDiv.style.display = 'block';
            errorDiv.innerText = `Amount exceeds outstanding balance of ${maxAmount.toFixed(2)}`;
            submitBtn.disabled = true;
        } else {
            errorDiv.style.display = 'none';
            errorDiv.innerText = '';
            submitBtn.disabled = false;
        }
    }

    document.addEventListener('input', function (e) {
        if (e.target.matches('.debit-amount')) updateCreditAmount();
    });

    document.addEventListener('click', function (e) {
        if (e.target.matches('.add-row')) {
            const container = document.getElementById('debitRows');
            const index = rowCount++;

            const row = document.createElement('div');
            row.className = 'debit-row row mb-2';
            row.innerHTML = `
                <div class="col-md-5">
                    <select name="transactions[${index}][debit_account_id]" class="form-control" required>
                        <option value="">-- Select Account --</option>
                        @foreach($cashAccounts as $acc)
                            <option value="{{ $acc->id }}">{{ $acc->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-5">
                    <input type="number" name="transactions[${index}][debit]" class="form-control debit-amount"
                           step="0.01" required>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="button" class="btn btn-sm btn-danger remove-row">−</button>
                </div>
            `;
            container.appendChild(row);
        }

        if (e.target.matches('.remove-row')) {
            e.target.closest('.debit-row').remove();
            updateCreditAmount();
        }
    });
</script>
@endsection
