@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Edit Item</h2>
    <form action="{{ route('items.update', $item->code) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label for="code">Item Code</label>
            <input type="text" name="code" class="form-control" required value="{{ old('code', $item->code) }}" readonly>
        </div>

        <div class="mb-3">
            <label for="name">Item Name</label>
            <input type="text" name="name" class="form-control" required value="{{ old('name', $item->name) }}">
        </div>

        <div class="mb-3">
            <label for="description">Description</label>
            <textarea name="description" class="form-control">{{ old('description', $item->description) }}</textarea>
        </div>

        <button type="submit" class="btn btn-primary">Update Item</button>
    </form>
</div>
@endsection
