@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Items</h2>
    <a href="{{ route('items.create') }}" class="btn btn-primary mb-3">Create Item</a>
    <table class="table">
        <thead>
            <tr>
                <th>Code</th>
                <th>Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($items as $item)
                <tr>
                    <td>{{ $item->code }}</td>
                    <td>{{ $item->name }}</td>
                    <td>
                        <a href="{{ route('items.edit', $item->code) }}" class="btn btn-warning">Edit</a>
                        <form action="{{ route('items.destroy', $item->code) }}" method="POST" style="display:inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
