@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>{{ isset($journal) ? 'Edit' : 'Create' }} Journal Entry</h2>
    <form action="{{ isset($journal) ? route('admin.journals.update', $journal) : route('admin.journals.store') }}" method="POST">

        @csrf
        @if(isset($journal)) @method('PUT') @endif

        {{-- Journal Entry Fields --}}
        <div class="mb-3">
            <label>Date</label>
            <input name="date" type="date" value="{{ old('date', $journal->date ?? '') }}" class="form-control" required>
        </div>

        <div class="mb-3">
            <label>Description</label>
            <textarea name="description" class="form-control" required>{{ old('description', $journal->description ?? '') }}</textarea>
        </div>

        <div class="mb-3">
            <label>Allocation</label>
            <input name="allocation" type="text" value="{{ old('allocation', $journal->allocation ?? '') }}" class="form-control">
        </div>

        <div class="mb-3">
            <label>Invoice ID</label>
            <input name="inv_id" type="number" value="{{ old('inv_id', $journal->inv_id ?? '') }}" class="form-control">
        </div>

        <div class="mb-3">
            <label>Invoice Date</label>
            <input name="inv_date" type="date" value="{{ old('inv_date', $journal->inv_date ?? '') }}" class="form-control">
        </div>

        <div class="mb-3">
            <label>Customer</label>
            <select name="customer_id" class="form-select">
                <option value="">-- Select Customer --</option>
                @foreach($customers as $customer)
                    <option value="{{ $customer->id }}" @selected(old('customer_id', $journal->customer_id ?? '') == $customer->id)>
                        {{ $customer->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label>Vendor</label>
            <select name="vendor_id" class="form-select">
                <option value="">-- Select Vendor --</option>
                @foreach($vendors as $vendor)
                    <option value="{{ $vendor->id }}" @selected(old('vendor_id', $journal->vendor_id ?? '') == $vendor->id)>
                        {{ $vendor->company_name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label>Equipment</label>
            <select name="machine_id" class="form-select">
                <option value="">-- Select Equipment --</option>
                @foreach($equipments as $eq)
                    <option value="{{ $eq->id }}" @selected(old('machine_id', $journal->machine_id ?? '') == $eq->id)>
                        {{ $eq->eq_id }} - {{ $eq->description }}
                    </option>
                @endforeach
            </select>
        </div>

        <hr>

        {{-- Double-Entry Transactions --}}
        <h5>Double Entry Transactions</h5>
        @php $lines = old('transactions', $journal->transactions ?? [null]) @endphp
        @foreach($lines as $i => $line)
            <div class="row mb-3">
                <div class="col-md-4">
                    <label>Debit Account</label>
                    <select name="transactions[{{ $i }}][debit_account_id]" class="form-select">
                        <option value="">-- Select Account --</option>
                        @foreach($accounts as $acc)
                            <option value="{{ $acc->id }}" @selected(old("transactions.$i.debit_account_id", $line->debit_account_id ?? '') == $acc->id)>
                                {{ $acc->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label>Amount</label>
                    <input type="number" step="0.01" name="transactions[{{ $i }}][debit]" class="form-control"
                           value="{{ old("transactions.$i.debit", $line->debit ?? '') }}" placeholder="Debit">
                </div>
                <div class="col-md-4">
                    <label>Credit Account</label>
                    <select name="transactions[{{ $i }}][credit_account_id]" class="form-select">
                        <option value="">-- Select Account --</option>
                        @foreach($accounts as $acc)
                            <option value="{{ $acc->id }}" @selected(old("transactions.$i.credit_account_id", $line->credit_account_id ?? '') == $acc->id)>
                                {{ $acc->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label>Amount</label>
                    <input type="number" step="0.01" name="transactions[{{ $i }}][credit]" class="form-control"
                           value="{{ old("transactions.$i.credit", $line->credit ?? '') }}" placeholder="Credit">
                </div>
            </div>
            <div class="mb-3">
                <label>Transaction Description</label>
                <input type="text" name="transactions[{{ $i }}][description]" class="form-control"
                       value="{{ old("transactions.$i.description", $line->description ?? '') }}">
            </div>
            <hr>
        @endforeach

        <button type="submit" class="btn btn-success">{{ isset($journal) ? 'Update' : 'Post Entry' }}</button>
    </form>
</div>
@endsection
