@extends('adminlte::page')


@section('content')
<div class="container">
    <h2>{{ isset($journal) ? 'Edit' : 'Create' }} Journal Entry</h2>
    <form action="{{ isset($journal) ? route('journals.update', $journal) : route('journals.store') }}" method="POST">
        @csrf
        @if(isset($journal)) @method('PUT') @endif

        <input name="date" type="date" value="{{ old('date', $journal->date ?? '') }}" class="form-control mb-2" required>
        <textarea name="description" class="form-control mb-2" required>{{ old('description', $journal->description ?? '') }}</textarea>

        <h5>Transactions</h5>
        <div id="transactions">
            @php $lines = old('transactions', $journal->transactions ?? [null]) @endphp
            @foreach($lines as $i => $line)
                <div class="row mb-2">
                    <div class="col">
                        <select name="transactions[{{ $i }}][account_id]" class="form-select">
                            @foreach($accounts as $acc)
                                <option value="{{ $acc->id }}" @selected(old(\"transactions.$i.account_id\", $line->account_id ?? '') == $acc->id)>
                                    {{ $acc->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col">
                        <input type="number" step=\"0.01\" name="transactions[{{ $i }}][debit]" class="form-control"
                               value="{{ old(\"transactions.$i.debit\", $line->debit ?? '') }}" placeholder="Debit">
                    </div>
                    <div class="col">
                        <input type="number" step=\"0.01\" name="transactions[{{ $i }}][credit]" class="form-control"
                               value="{{ old(\"transactions.$i.credit\", $line->credit ?? '') }}" placeholder="Credit">
                    </div>
                </div>
            @endforeach
        </div>

        <button type="submit" class="btn btn-success">{{ isset($journal) ? 'Update' : 'Post' }}</button>
    </form>
</div>
@endsection
