@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>General Journal</h2>

    <a href="{{ route('admin.journals.create') }}" class="btn btn-primary mb-3">Create New Journal Entry</a>

    @if($journals->isEmpty())
        <p>No journal entries found.</p>
    @else
        <table class="table table-bordered">
            <thead class="table-light">
                <tr>
                    <th>Date</th>
                    <th>Account</th>
                    <th>AC Code</th>
                    <th>Debit</th>
                    <th>Credit</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($journals as $journal)
                    @foreach($journal->transactions as $i => $t)
                        <tr>
                            @if($i === 0)
                                <td rowspan="{{ $journal->transactions->count() + 1 }}">
                                    {{ \Carbon\Carbon::parse($journal->date)->format('d/m/Y') }}
                                </td>
                            @endif
                            <td>{{ $t->account->name }}</td>
                            <td>{{ $t->account->code ?? 'N/A' }}</td>
                            <td>{{ $t->debit > 0 ? number_format($t->debit, 2) : '' }}</td>
                            <td>{{ $t->credit > 0 ? number_format($t->credit, 2) : '' }}</td>
                            @if($i === 0)
                                <td rowspan="{{ $journal->transactions->count() + 1 }}" class="align-top">
                                    <a href="{{ route('admin.journals.edit', $journal) }}" class="btn btn-sm btn-warning mb-2">Edit</a>
                                    <form action="{{ route('admin.journals.destroy', $journal) }}" method="POST" onsubmit="return confirm('Delete this journal?')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-sm btn-danger">Delete</button>
                                    </form>
                                </td>
                            @endif
                        </tr>
                    @endforeach
                    {{-- Description Row --}}
                    <tr class="table-secondary">
                        <td colspan="5"><em>{{ $journal->description }}</em></td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>
@endsection
