@extends('adminlte::page')

@section('title', 'Create Permission')

@section('content_header')
    <h1>Create New Permission</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Permission Details</h3>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.permissions.store') }}">
                @csrf

                <div class="form-group">
                    <label for="name">Permission Name <span class="text-danger">*</span></label>
                    <input type="text"
                           name="name"
                           id="name"
                           class="form-control @error('name') is-invalid @enderror"
                           value="{{ old('name') }}"
                           placeholder="e.g., manage users, view reports, etc."
                           required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="form-text text-muted">
                        Use lowercase with spaces. Examples: "manage users", "view dashboard", "create invoices"
                    </small>
                </div>

                <div class="form-group">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Create Permission
                    </button>
                    <a href="{{ route('admin.permissions.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>

    <div class="card card-info">
        <div class="card-header">
            <h3 class="card-title">
                <i class="fas fa-info-circle"></i> Permission Naming Convention
            </h3>
        </div>
        <div class="card-body">
            <p><strong>Best Practices:</strong></p>
            <ul>
                <li>Use lowercase letters</li>
                <li>Use spaces to separate words</li>
                <li>Start with an action verb (manage, view, create, edit, delete, etc.)</li>
                <li>Be specific and descriptive</li>
            </ul>

            <p class="mt-3"><strong>Examples:</strong></p>
            <ul>
                <li><code>manage users</code> - Full access to user management</li>
                <li><code>view invoices</code> - View-only access to invoices</li>
                <li><code>create journals</code> - Ability to create journal entries</li>
                <li><code>approve petty cash</code> - Ability to approve expenses</li>
            </ul>
        </div>
    </div>
@stop
