@extends('adminlte::page')

@section('title', 'Permissions')

@section('content_header')
    <h1>Permissions</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Permissions</h3>
            <div class="card-tools">
                <a href="{{ route('admin.permissions.create') }}" class="btn btn-sm btn-primary">
                    <i class="fas fa-plus"></i> Create Permission
                </a>
            </div>
        </div>
        <div class="card-body">
            @foreach($groupedPermissions as $category => $perms)
                <h5 class="mt-3">{{ ucfirst($category) }}</h5>
                <div class="row">
                    @foreach($perms as $permission)
                        <div class="col-md-3">
                            <span class="badge badge-secondary">{{ $permission->name }}</span>
                        </div>
                    @endforeach
                </div>
            @endforeach
        </div>
    </div>
@stop
