@extends('adminlte::page')

@section('title', 'View Expense Details')

@section('content_header')
<h1>Expense Details</h1>
@stop

@section('content')

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Expense Information</h3>
            </div>
            <div class="card-body">
                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show">
                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
                @endif

                @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
                @endif

                <form method="POST" action="{{ route('admin.pettycash.approvals.update', $expense->id) }}" id="editExpenseForm">
                    @csrf
                    @method('PUT')

                    <table class="table table-bordered">
                        <tr>
                            <th width="30%">Employee</th>
                            <td>{{ $expense->user->name }}</td>
                        </tr>
                        <tr>
                            <th>Expense Date</th>
                            <td>{{ \Carbon\Carbon::parse($expense->expense_date)->format('d-m-Y') }}</td>
                        </tr>
                        <tr>
                            <th>Expense Type</th>
                            <td>
                                @if($expense->status === 'pending')
                                <select name="expense_account_id" class="form-control" required>
                                    @foreach($expenseAccounts as $account)
                                    <option value="{{ $account->id }}"
                                        {{ $expense->expense_account_id == $account->id ? 'selected' : '' }}>
                                        {{ $account->code }} - {{ $account->name }}
                                    </option>
                                    @endforeach
                                </select>
                                @else
                                {{ $expense->expenseAccount->code }} - {{ $expense->expenseAccount->name }}
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Petty Cash Account</th>
                            <td>{{ $expense->pettyCashAccount->name }}</td>
                        </tr>
                        <tr>
                            <th>Amount</th>
                            <td><strong class="text-primary">{{ number_format($expense->amount, 2) }}</strong></td>
                        </tr>
                        @if($expense->is_vat_inclusive && $expense->vat_amount > 0)
                        <tr>
                            <th>VAT Details</th>
                            <td>
                                <div class="card bg-light mb-0">
                                    <div class="card-body p-2">
                                        <table class="table table-sm mb-0">
                                            <tr>
                                                <td><strong>Amount Excluding VAT:</strong></td>
                                                <td class="text-right">{{ number_format($expense->amount_excluding_vat, 2) }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>VAT (5%):</strong></td>
                                                <td class="text-right">{{ number_format($expense->vat_amount, 2) }}</td>
                                            </tr>
                                            <tr class="font-weight-bold">
                                                <td>Total:</td>
                                                <td class="text-right">{{ number_format($expense->amount, 2) }}</td>
                                            </tr>
                                            @if($expense->vat_claimable !== null)
                                            <tr>
                                                <td><strong>VAT Claimable:</strong></td>
                                                <td class="text-right">
                                                    @if($expense->vat_claimable)
                                                    <span class="badge badge-success">Yes</span>
                                                    @else
                                                    <span class="badge badge-secondary">No</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            @endif
                                        </table>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endif
                        <tr>
                            <th>Description</th>
                            <td>
                                @if($expense->status === 'pending')
                                <textarea name="description"
                                    class="form-control"
                                    rows="2"
                                    required>{{ $expense->description }}</textarea>
                                @else
                                {{ $expense->description }}
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td>
                                @if($expense->status === 'pending')
                                <span class="badge badge-warning">Pending</span>
                                @elseif($expense->status === 'approved')
                                <span class="badge badge-success">Approved</span>
                                @else
                                <span class="badge badge-danger">Rejected</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Submitted At</th>
                            <td>{{ $expense->created_at->format('d-m-Y H:i') }}</td>
                        </tr>
                        @if($expense->status === 'approved' || $expense->status === 'rejected')
                        <tr>
                            <th>{{ $expense->status === 'approved' ? 'Approved' : 'Rejected' }} By</th>
                            <td>
                                @if($expense->approvedBy)
                                {{ $expense->approvedBy->name }}
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>{{ $expense->status === 'approved' ? 'Approved' : 'Rejected' }} At</th>
                            <td>
                                @if($expense->approved_at)
                                {{ \Carbon\Carbon::parse($expense->approved_at)->format('d-m-Y H:i') }}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @if($expense->status === 'rejected' && $expense->rejection_reason)
                        <tr>
                            <th>Rejection Reason</th>
                            <td class="text-danger">{{ $expense->rejection_reason }}</td>
                        </tr>
                        @endif
                    </table>

                    @if($expense->status === 'pending')
                    <div class="mt-3">
                        <button type="submit" class="btn btn-primary" form="editExpenseForm">
                            <i class="fas fa-save"></i> Save Changes
                        </button>
                    </div>
                    @endif
                </form>

                @if($expense->status === 'pending')
                <div class="mt-3">
                    @if($expense->is_vat_inclusive && $expense->vat_amount > 0)
                    <div class="card bg-light mb-3">
                        <div class="card-body">
                            <h6 class="card-title mb-3"></h6>
                            <div class="form-group mb-0">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox"
                                        class="custom-control-input"
                                        id="vat_claimable"
                                        name="vat_claimable"
                                        value="1">
                                    <label class="custom-control-label font-weight-bold" for="vat_claimable">
                                        VAT is Claimable
                                    </label>
                                </div>

                            </div>
                        </div>
                    </div>
                    @endif

                    <form method="POST"
                        action="{{ route('admin.pettycash.approvals.approve', $expense->id) }}"
                        id="approveForm"
                        style="display:inline;">
                        @csrf
                        <input type="hidden" name="vat_claimable" id="vat_claimable_hidden" value="0">
                        <button class="btn btn-success"
                            onclick="return confirmApprovalDetail()">
                            <i class="fas fa-check"></i> Approve
                        </button>
                    </form>

                    <button class="btn btn-danger"
                        data-toggle="modal"
                        data-target="#rejectModal">
                        <i class="fas fa-times"></i> Reject
                    </button>

                    <!-- Reject Modal -->
                    <div class="modal fade" id="rejectModal">
                        <div class="modal-dialog">
                            <form method="POST"
                                action="{{ route('admin.pettycash.approvals.reject', $expense->id) }}">
                                @csrf
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Reject Expense</h5>
                                        <button type="button" class="close" data-dismiss="modal">
                                            <span>&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <textarea name="reason"
                                            class="form-control"
                                            rows="3"
                                            placeholder="Reason for rejection"
                                            required></textarea>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-danger">Reject</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Receipt/Invoice Images</h3>
            </div>
            <div class="card-body">
                @if($expense->receipt_images && count($expense->receipt_images) > 0)
                <div class="text-center">
                    <p class="text-muted small mb-3">{{ count($expense->receipt_images) }} image(s) uploaded</p>
                    @foreach($expense->receipt_images as $index => $image)
                    <div class="mb-3">
                        <a href="{{ asset('storage/' . $image) }}" target="_blank">
                            <img src="{{ asset('storage/' . $image) }}"
                                alt="Receipt {{ $index + 1 }}"
                                class="img-fluid img-thumbnail"
                                style="max-height: 300px; cursor: pointer;">
                        </a>
                        <p class="mt-1 text-muted small">Image {{ $index + 1 }} of {{ count($expense->receipt_images) }}</p>
                    </div>
                    @endforeach
                    <p class="mt-2 text-muted small">Click images to view full size</p>
                </div>
                @else
                <div class="text-center text-muted">
                    <i class="fas fa-receipt fa-3x mb-3"></i>
                    <p>No receipts/invoices uploaded</p>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<div class="mt-3">
    <a href="{{ route('admin.pettycash.approvals.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Approvals
    </a>
</div>

@stop

@section('js')
<script>
    function confirmApprovalDetail() {
        // Get the checkbox value
        const checkbox = document.getElementById('vat_claimable');
        const hiddenInput = document.getElementById('vat_claimable_hidden');

        // Update hidden input based on checkbox state
        if (checkbox && checkbox.checked) {
            hiddenInput.value = '1';
        } else if (checkbox) {
            hiddenInput.value = '0';
        }

        return confirm('Approve this expense?');
    }
</script>
@stop