@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Create Quote</h2>
    <form action="{{ route('quotes.store') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label for="quote_number">Quote Number</label>
            <input type="text" name="quote_number" class="form-control" required value="{{ old('quote_number') }}">
        </div>

        <div class="mb-3">
            <label for="customer_id">Customer</label>
            <select name="customer_id" class="form-control" required>
                <option value="">Select Customer</option>
                @foreach ($customers as $customer)
                    <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>
                        {{ $customer->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="quote_date">Quote Date</label>
            <input type="date" name="quote_date" class="form-control" required value="{{ old('quote_date') }}">
        </div>

        <div class="mb-3">
            <label for="project_site">Project Site</label>
            <textarea name="project_site" class="form-control">{{ old('project_site') }}</textarea>
        </div>

        <div class="mb-3">
            <label for="subtotal">Subtotal</label>
            <input type="number" name="subtotal" class="form-control" step="0.01" value="{{ old('subtotal') }}">
        </div>

        <div class="mb-3">
            <label for="discount">Discount</label>
            <input type="number" name="discount" class="form-control" step="0.01" value="{{ old('discount') }}">
        </div>

        <div class="mb-3">
            <label for="taxable_total">Taxable Total</label>
            <input type="number" name="taxable_total" class="form-control" step="0.01" value="{{ old('taxable_total') }}">
        </div>

        <div class="mb-3">
            <label for="tax">Tax</label>
            <input type="number" name="tax" class="form-control" step="0.01" value="{{ old('tax') }}">
        </div>

        <div class="mb-3">
            <label for="total">Total</label>
            <input type="number" name="total" class="form-control" step="0.01" value="{{ old('total') }}">
        </div>

        <button type="submit" class="btn btn-success">Create Quote</button>
    </form>
</div>
@endsection
