@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Quotes</h2>
    <a href="{{ route('quotes.create') }}" class="btn btn-primary mb-3">Create Quote</a>
    <table class="table">
        <thead>
            <tr>
                <th>Quote Number</th>
                <th>Customer</th>
                <th>Total</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($quotes as $quote)
                <tr>
                    <td>{{ $quote->quote_number }}</td>
                    <td>{{ $quote->customer->name }}</td>
                    <td>{{ $quote->total }}</td>
                    <td>
                        <a href="{{ route('quotes.edit', $quote->id) }}" class="btn btn-warning">Edit</a>
                        <form action="{{ route('quotes.destroy', $quote->id) }}" method="POST" style="display:inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
