@extends('adminlte::page')

@section('title', 'Create Role')

@section('content_header')
    <h1>Create New Role</h1>
@stop

@section('content')
    <div class="card">
        <form action="{{ route('admin.roles.store') }}" method="POST">
            @csrf
            <div class="card-body">
                <div class="form-group">
                    <label for="name">Role Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" required>
                    @error('name')<span class="invalid-feedback">{{ $message }}</span>@enderror
                    <small class="form-text text-muted">Enter a unique role name (e.g., "manager", "accountant", "staff")</small>
                </div>

                <hr>

                <h5>Assign Permissions</h5>
                <p class="text-muted">Select the permissions this role should have:</p>

                @foreach($permissions as $category => $perms)
                    <div class="card card-outline card-primary mb-3">
                        <div class="card-header">
                            <h5 class="card-title">
                                <input type="checkbox" class="select-all" data-category="{{ $category }}">
                                <strong>{{ ucfirst($category) }} Permissions</strong>
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                @foreach($perms as $permission)
                                    <div class="col-md-4 col-sm-6">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox"
                                                   class="custom-control-input permission-checkbox category-{{ $category }}"
                                                   name="permissions[]"
                                                   value="{{ $permission->name }}"
                                                   id="perm_{{ $permission->id }}"
                                                   {{ in_array($permission->name, old('permissions', [])) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="perm_{{ $permission->id }}">
                                                {{ $permission->name }}
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Create Role
                </button>
                <a href="{{ route('admin.roles.index') }}" class="btn btn-default">Cancel</a>
            </div>
        </form>
    </div>
@stop

@section('js')
<script>
    // Select all permissions in a category
    document.querySelectorAll('.select-all').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const category = this.dataset.category;
            const categoryCheckboxes = document.querySelectorAll('.category-' + category);
            categoryCheckboxes.forEach(cb => {
                cb.checked = this.checked;
            });
        });
    });
</script>
@stop
