@extends('adminlte::page')

@section('title', 'Roles')

@section('content_header')
    <h1>Roles & Permissions Management</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Roles</h3>
            <div class="card-tools">
                <a href="{{ route('admin.roles.create') }}" class="btn btn-sm btn-primary">
                    <i class="fas fa-plus"></i> Create Role
                </a>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Role Name</th>
                        <th>Permissions Count</th>
                        <th>Users Count</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($roles as $role)
                        <tr>
                            <td>
                                <strong>{{ ucfirst($role->name) }}</strong>
                                @if($role->name === 'admin')
                                    <span class="badge badge-danger">Super Admin</span>
                                @endif
                            </td>
                            <td>
                                <span class="badge badge-info">{{ $role->permissions->count() }} permissions</span>
                            </td>
                            <td>
                                <span class="badge badge-secondary">{{ $role->users->count() }} users</span>
                            </td>
                            <td>
                                <a href="{{ route('admin.roles.show', $role) }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i> View
                                </a>
                                <a href="{{ route('admin.roles.edit', $role) }}" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                @if($role->name !== 'admin')
                                    <form action="{{ route('admin.roles.destroy', $role) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure? This will affect {{ $role->users->count() }} users.');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">No roles found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="card-footer">
            {{ $roles->links() }}
        </div>
    </div>
@stop
