@extends('adminlte::page')

@section('title', 'Dashboard')

@section('content_header')
    <h1>Welcome, {{ $user->name }}!</h1>
@stop

@section('content')

{{-- Profile Summary Card - Desktop --}}
<div class="row d-none d-md-flex">
    <div class="col-md-12">
        <div class="card card-widget widget-user">
            <div class="widget-user-header bg-gradient-primary">
                <h3 class="widget-user-username">{{ $user->name }}</h3>
                <h5 class="widget-user-desc">{{ $user->email }}</h5>
            </div>
            @if($employee && $employee->photo)
                <div class="widget-user-image">
                    <img class="img-circle elevation-2" src="{{ asset('storage/' . $employee->photo) }}" alt="User Avatar">
                </div>
            @else
                <div class="widget-user-image">
                    <img class="img-circle elevation-2" src="{{ asset('vendor/adminlte/dist/img/user2-160x160.jpg') }}" alt="User Avatar">
                </div>
            @endif
            <div class="card-footer">
                <div class="row">
                    <div class="col-sm-4 border-right">
                        <div class="description-block">
                            <h5 class="description-header">{{ $employee->employee_id ?? 'N/A' }}</h5>
                            <span class="description-text">EMPLOYEE ID</span>
                        </div>
                    </div>
                    <div class="col-sm-4 border-right">
                        <div class="description-block">
                            <h5 class="description-header">{{ $employee->department->name ?? 'N/A' }}</h5>
                            <span class="description-text">DEPARTMENT</span>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="description-block">
                            <h5 class="description-header">{{ $employee->designation->name ?? 'N/A' }}</h5>
                            <span class="description-text">DESIGNATION</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Profile Summary Card - Mobile --}}
<div class="row d-md-none">
    <div class="col-12">
        <div class="card bg-gradient-primary">
            <div class="card-body text-center text-white">
                @if($employee && $employee->photo)
                    <img class="img-circle elevation-2 mb-3" src="{{ asset('storage/' . $employee->photo) }}" alt="User Avatar" style="width: 100px; height: 100px;">
                @else
                    <img class="img-circle elevation-2 mb-3" src="{{ asset('vendor/adminlte/dist/img/user2-160x160.jpg') }}" alt="User Avatar" style="width: 100px; height: 100px;">
                @endif
                <h4 class="mb-1">{{ $user->name }}</h4>
                <p class="mb-3">{{ $user->email }}</p>
                <div class="row">
                    <div class="col-12 mb-2">
                        <small>EMPLOYEE ID</small>
                        <h6 class="font-weight-bold">{{ $employee->employee_id ?? 'N/A' }}</h6>
                    </div>
                    <div class="col-6">
                        <small>DEPARTMENT</small>
                        <h6 class="font-weight-bold">{{ $employee->department->name ?? 'N/A' }}</h6>
                    </div>
                    <div class="col-6">
                        <small>DESIGNATION</small>
                        <h6 class="font-weight-bold">{{ $employee->designation->name ?? 'N/A' }}</h6>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    {{-- Attendance Summary Card --}}
    <div class="col-lg-6 col-12">
        <div class="card card-primary card-outline">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-calendar-check"></i> My Attendance (This Month)
                </h3>
                <div class="card-tools">
                    @can('mark own attendance')
                    <a href="{{ route('admin.hr.attendance.mark') }}" class="btn btn-tool btn-sm" title="Mark Attendance">
                        <i class="fas fa-user-check"></i>
                    </a>
                    @endcan
                    @can('view own attendance')
                    <a href="{{ route('admin.hr.attendance.index') }}" class="btn btn-tool btn-sm" title="View All Attendance">
                        <i class="fas fa-arrow-right"></i>
                    </a>
                    @endcan
                </div>
            </div>
            <div class="card-body">
                @if($attendanceStats)
                    <div class="row">
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-check-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Days Present</span>
                                    <span class="info-box-number">{{ $attendanceStats['days_present'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-calendar-times"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Days On Leave</span>
                                    <span class="info-box-number">{{ $attendanceStats['days_on_leave'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box {{ $attendanceStats['total_ot'] >= 0 ? 'bg-info' : 'bg-danger' }}">
                                <span class="info-box-icon"><i class="fas fa-clock"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total OT</span>
                                    <span class="info-box-number">
                                        {{ $attendanceStats['total_ot'] >= 0 ? '+' : '' }}{{ number_format($attendanceStats['total_ot'], 2) }} hrs
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box bg-secondary">
                                <span class="info-box-icon"><i class="fas fa-hourglass-half"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Pending Approvals</span>
                                    <span class="info-box-number">{{ $attendanceStats['pending_approvals'] }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> No employee record found for your account.
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- Petty Cash Summary Card --}}
    <div class="col-lg-6 col-12">
        <div class="card card-success card-outline">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-wallet"></i> My Petty Cash
                </h3>
                @can('view own petty cash')
                <div class="card-tools">
                    <a href="{{ route('admin.pettycash.my-ledger') }}" class="btn btn-tool btn-sm">
                        <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
                @endcan
            </div>
            <div class="card-body">
                @if($pettyCashStats)
                    <div class="row mb-3">
                        <div class="col-12">
                            <h4 class="text-center">
                                <strong>{{ $pettyCashStats['account_name'] }}</strong>
                            </h4>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box bg-gradient-success">
                                <span class="info-box-icon"><i class="fas fa-coins"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Current Balance</span>
                                    <span class="info-box-number">{{ number_format($pettyCashStats['balance'], 2) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box bg-gradient-warning">
                                <span class="info-box-icon"><i class="fas fa-clock"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Pending Expenses</span>
                                    <span class="info-box-number">{{ $pettyCashStats['pending_expenses'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 mb-2">
                            <div class="info-box bg-gradient-info">
                                <span class="info-box-icon"><i class="fas fa-receipt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Approved This Month</span>
                                    <span class="info-box-number">{{ number_format($pettyCashStats['approved_this_month'], 2) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    @can('add petty cash expense')
                    <div class="text-center">
                        <a href="{{ route('admin.pettycash.my-expense') }}" class="btn btn-success btn-block d-md-inline-block">
                            <i class="fas fa-plus"></i> Add New Expense
                        </a>
                    </div>
                    @endcan
                @else
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> No petty cash account assigned to you.
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

{{-- Quick Actions --}}
<div class="row">
    <div class="col-md-12">
        <div class="card card-outline card-info">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-bolt"></i> Quick Actions
                </h3>
            </div>
            <div class="card-body">
                <div class="row">
                    @can('mark own attendance')
                    <div class="col-lg-3 col-6">
                        <a href="{{ route('admin.hr.attendance.mark') }}" class="btn btn-app btn-block bg-danger">
                            <i class="fas fa-user-check"></i> Mark Attendance
                        </a>
                    </div>
                    @endcan

                    @can('view own attendance')
                    <div class="col-lg-3 col-6">
                        <a href="{{ route('admin.hr.attendance.index') }}" class="btn btn-app btn-block bg-primary">
                            <i class="fas fa-calendar-check"></i> My Attendance
                        </a>
                    </div>
                    @endcan

                    @can('view own petty cash')
                    <div class="col-lg-3 col-6">
                        <a href="{{ route('admin.pettycash.my-ledger') }}" class="btn btn-app btn-block bg-success">
                            <i class="fas fa-wallet"></i> My Petty Cash
                        </a>
                    </div>
                    @endcan

                    @can('add petty cash expense')
                    <div class="col-lg-3 col-6">
                        <a href="{{ route('admin.pettycash.my-expense') }}" class="btn btn-app btn-block bg-warning">
                            <i class="fas fa-receipt"></i> Add Expense
                        </a>
                    </div>
                    @endcan

                    <div class="col-lg-3 col-6">
                        <a href="#" class="btn btn-app btn-block bg-info">
                            <i class="fas fa-user-circle"></i> My Profile
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@stop
