

<?php $__env->startSection('title', 'Petty Cash Overview'); ?>

<?php $__env->startSection('content_header'); ?>
<h1>Petty Cash Management</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Individual Petty Cash Accounts</h3>
    </div>

    <div class="card-body p-0">
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th>Code</th>
                    <th>Account</th>
                    <th>Employee</th>
                    <th class="text-right">Balance</th>
                    <th class="text-right">Action</th>
                </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($account->code); ?></td>
                    <td><?php echo e($account->name); ?></td>
                    <td><?php echo e($account->user->name ?? '—'); ?></td>
                    <td class="text-right">
                        <?php echo e(number_format($account->balance, 2)); ?>

                    </td>
                    <td class="text-right">
                        <a href="<?php echo e(route('admin.pettycash.show', $account->id)); ?>"
                           class="btn btn-sm btn-primary">
                            View Ledger
                        </a>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('topup petty cash')): ?>
                        <a href="<?php echo e(route('admin.pettycash.topup', $account->id)); ?>"
                           class="btn btn-sm btn-success">
                            Top Up
                        </a>
                    <?php endif; ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laravel\rms\resources\views/admin/pettycash/index.blade.php ENDPATH**/ ?>