

<?php $__env->startSection('content'); ?>
<div class="container">
    <h2>Create New Account</h2>
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.accounts.store')); ?>" method="POST">

        <?php echo csrf_field(); ?>

        <div class="mb-3">
            <label for="code" class="form-label">Account Code</label>
            <input type="text" name="code" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="name" class="form-label">Account Name</label>
            <input type="text" name="name" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="type" class="form-label">Account Type</label>
            <select name="type" class="form-select" required>
                <option value="">Select Type</option>
                <option value="asset">Asset</option>
                <option value="liability">Liability</option>
                <option value="equity">Equity</option>
                <option value="income">Income</option>
                <option value="expense">Expense</option>
                <option value="cogs">COGS</option>
            </select>
        </div>

        <div class="mb-3">
            <label for="parent_id" class="form-label">Parent Account (optional)</label>
            <select name="parent_id" id="parent_id" class="form-select">
                <option value="">None</option>
                <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($account->id); ?>"><?php echo e($account->code); ?> - <?php echo e($account->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3" id="user_select_div" style="display: none;">
            <label for="user_id" class="form-label">Assign to User <span class="text-danger">*</span></label>
            <select name="user_id" id="user_id" class="form-select">
                <option value="">Select User</option>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?> (<?php echo e($user->email); ?>)</option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <small class="form-text text-muted">This petty cash account will be assigned to the selected user.</small>
        </div>

        <div class="form-check mb-2">
            <input type="checkbox" name="is_posting" class="form-check-input" id="is_posting"
                <?php echo e(old('is_posting', $account->is_posting ?? true) ? 'checked' : ''); ?>>
            <label class="form-check-label" for="is_posting">Is Posting Account?</label>
        </div>

        <button type="submit" class="btn btn-primary">Create Account</button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const parentSelect = document.getElementById('parent_id');
        const userSelectDiv = document.getElementById('user_select_div');
        const userSelect = document.getElementById('user_id');
        const pettyCashAccountId = <?php echo e($pettyCashAccountId ?? 'null'); ?>;

        function toggleUserSelect() {
            const selectedParentId = parseInt(parentSelect.value);

            if (selectedParentId === pettyCashAccountId) {
                userSelectDiv.style.display = 'block';
                userSelect.required = true;
            } else {
                userSelectDiv.style.display = 'none';
                userSelect.required = false;
                userSelect.value = '';
            }
        }

        parentSelect.addEventListener('change', toggleUserSelect);

        // Check on page load in case of validation errors
        toggleUserSelect();
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laravel\rms\resources\views/admin/accounts/create.blade.php ENDPATH**/ ?>