

<?php $__env->startSection('title', 'My Petty Cash'); ?>

<?php $__env->startSection('content_header'); ?>
<h1>My Petty Cash Ledger</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <?php echo e(session('success')); ?>

        <button type="button" class="close" data-dismiss="alert">&times;</button>
    </div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <button type="button" class="close" data-dismiss="alert">&times;</button>
    </div>
<?php endif; ?>


<?php if($pendingExpenses->isNotEmpty()): ?>
<div class="card mb-3">
    <div class="card-header bg-warning">
        <h3 class="card-title">
            <i class="fas fa-clock"></i> Pending Approval
        </h3>
    </div>

    
    <div class="card-body p-0 d-none d-md-block">
        <table class="table table-striped table-hover mb-0">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Expense Type</th>
                    <th>Description</th>
                    <th class="text-right">Amount</th>
                    <th>Receipt</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $pendingExpenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(\Carbon\Carbon::parse($expense->expense_date)->format('d-m-Y')); ?></td>
                    <td><?php echo e($expense->expenseAccount->code); ?> - <?php echo e($expense->expenseAccount->name); ?></td>
                    <td><?php echo e($expense->description); ?></td>
                    <td class="text-right"><?php echo e(number_format($expense->amount, 2)); ?></td>
                    <td>
                        <?php if($expense->receipt_images && count($expense->receipt_images) > 0): ?>
                            <span class="text-success">
                                <i class="fas fa-image"></i> <?php echo e(count($expense->receipt_images)); ?> image(s)
                            </span>
                        <?php else: ?>
                            <span class="text-muted">
                                <i class="fas fa-times"></i> No receipts
                            </span>
                        <?php endif; ?>
                    </td>
                    <td class="text-center">
                        <a href="<?php echo e(route('admin.pettycash.my-expense.edit', $expense->id)); ?>"
                           class="btn btn-sm btn-primary"
                           title="Edit">
                            <i class="fas fa-edit"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    
    <div class="card-body d-md-none">
        <?php $__currentLoopData = $pendingExpenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="card mb-2">
            <div class="card-body p-3">
                <div class="d-flex justify-content-between align-items-start mb-2">
                    <h6 class="mb-0"><?php echo e(\Carbon\Carbon::parse($expense->expense_date)->format('d M Y')); ?></h6>
                    <span class="badge badge-warning">Pending</span>
                </div>

                <div class="mb-2">
                    <small class="text-muted">Expense Type</small>
                    <div class="font-weight-bold"><?php echo e($expense->expenseAccount->code); ?> - <?php echo e($expense->expenseAccount->name); ?></div>
                </div>

                <div class="mb-2">
                    <small class="text-muted">Description</small>
                    <div><?php echo e($expense->description); ?></div>
                </div>

                <div class="row mb-2">
                    <div class="col-6">
                        <small class="text-muted">Amount</small>
                        <div class="font-weight-bold text-danger"><?php echo e(number_format($expense->amount, 2)); ?></div>
                    </div>
                    <div class="col-6">
                        <small class="text-muted">Receipt</small>
                        <div>
                            <?php if($expense->receipt_images && count($expense->receipt_images) > 0): ?>
                                <span class="text-success">
                                    <i class="fas fa-image"></i> <?php echo e(count($expense->receipt_images)); ?>

                                </span>
                            <?php else: ?>
                                <span class="text-muted">
                                    <i class="fas fa-times"></i> None
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <a href="<?php echo e(route('admin.pettycash.my-expense.edit', $expense->id)); ?>"
                   class="btn btn-sm btn-primary btn-block">
                    <i class="fas fa-edit"></i> Edit Expense
                </a>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php endif; ?>


<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <strong><?php echo e($account->name); ?></strong>

        <div class="d-flex">

            
            <form method="GET" action="<?php echo e(route('admin.pettycash.my-ledger')); ?>" class="mr-2">
                <select name="month"
                        class="form-control"
                        onchange="this.form.submit()">
                    <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($month); ?>"
                            <?php echo e($selectedMonth === $month ? 'selected' : ''); ?>>
                            <?php echo e(\Carbon\Carbon::createFromFormat('Y-m', $month)->format('F Y')); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add petty cash expense')): ?>
            <a href="<?php echo e(route('admin.pettycash.my-expense')); ?>"
               class="btn btn-sm btn-danger">
                Add Expense
            </a>
            <?php endif; ?>

        </div>
    </div>


    
    <div class="card-body p-0 d-none d-md-block">
        <table class="table table-striped table-hover">
            <thead>
            <tr>
                <th>Date</th>
                <th>Description</th>
                <th class="text-right">Debit</th>
                <th class="text-right">Credit</th>
                <th class="text-right">Balance</th>
                <th class="text-center">Action</th>
            </tr>
            </thead>
            <tbody>
            <?php $balance = 0; ?>

            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $balance += ($tx->debit - $tx->credit);
                    // Find related petty cash expense (if it's a credit transaction)
                    $relatedExpense = null;
                    if ($tx->credit > 0) {
                        $key = $tx->journalEntry->date->format('Y-m-d') . '_' . $tx->credit;
                        $relatedExpense = $approvedExpenses->get($key);
                    }
                ?>
                <tr>

                    <td><?php echo e($tx->journalEntry->date->format('d-m-Y')); ?></td>
                    <td><?php echo e($tx->journalEntry->description); ?></td>
                    <td class="text-right"><?php echo e(number_format($tx->debit, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($tx->credit, 2)); ?></td>
                    <td class="text-right">
                        <?php echo e(number_format($balance, 2)); ?>

                    </td>
                    <td class="text-center">
                        <?php if($tx->credit > 0 && $relatedExpense): ?>
                            <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#viewModal<?php echo e($tx->id); ?>">
                                <i class="fas fa-eye"></i>
                            </button>

                            
                            <div class="modal fade" id="viewModal<?php echo e($tx->id); ?>" tabindex="-1" role="dialog">
                                <div class="modal-dialog modal-lg" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Transaction Details</h5>
                                            <button type="button" class="close" data-dismiss="modal">
                                                <span>&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row mb-3">
                                                <div class="col-md-6">
                                                    <strong>Date:</strong> <?php echo e($tx->journalEntry->date->format('d M Y')); ?>

                                                </div>
                                                <div class="col-md-6">
                                                    <strong>Amount:</strong> <?php echo e(number_format($tx->credit, 2)); ?>

                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <strong>Description:</strong><br>
                                                <?php echo e($relatedExpense->description); ?>

                                            </div>
                                            <div class="mb-3">
                                                <strong>Expense Account:</strong><br>
                                                <?php echo e($relatedExpense->expenseAccount->code); ?> - <?php echo e($relatedExpense->expenseAccount->name); ?>

                                            </div>
                                            <?php if($relatedExpense->receipt_images && count($relatedExpense->receipt_images) > 0): ?>
                                                <div class="mb-3">
                                                    <strong>Receipt Images:</strong><br>
                                                    <div class="row">
                                                        <?php $__currentLoopData = $relatedExpense->receipt_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="col-md-4 mb-3">
                                                                <a href="<?php echo e(asset('storage/' . $image)); ?>" target="_blank">
                                                                    <img src="<?php echo e(asset('storage/' . $image)); ?>"
                                                                         class="img-fluid img-thumbnail"
                                                                         alt="Receipt">
                                                                </a>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <div class="alert alert-info">
                                                    <i class="fas fa-info-circle"></i> No receipt images attached to this expense.
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <span class="text-muted">—</span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    
    <div class="card-body d-md-none">
        <?php $balance = 0; ?>

        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $balance += ($tx->debit - $tx->credit);
                // Find related petty cash expense (if it's a credit transaction)
                $relatedExpense = null;
                if ($tx->credit > 0) {
                    $key = $tx->journalEntry->date->format('Y-m-d') . '_' . $tx->credit;
                    $relatedExpense = $approvedExpenses->get($key);
                }
            ?>
            <div class="card mb-2">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <h6 class="mb-0"><?php echo e($tx->journalEntry->date->format('d M Y')); ?></h6>
                        <?php if($tx->debit > 0): ?>
                            <span class="badge badge-success">Debit</span>
                        <?php else: ?>
                            <span class="badge badge-danger">Credit</span>
                        <?php endif; ?>
                    </div>

                    <div class="mb-2">
                        <small class="text-muted">Description</small>
                        <div><?php echo e($tx->journalEntry->description); ?></div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-4">
                            <small class="text-muted">Debit</small>
                            <div class="font-weight-bold <?php echo e($tx->debit > 0 ? 'text-success' : 'text-muted'); ?>">
                                <?php echo e(number_format($tx->debit, 2)); ?>

                            </div>
                        </div>
                        <div class="col-4">
                            <small class="text-muted">Credit</small>
                            <div class="font-weight-bold <?php echo e($tx->credit > 0 ? 'text-danger' : 'text-muted'); ?>">
                                <?php echo e(number_format($tx->credit, 2)); ?>

                            </div>
                        </div>
                        <div class="col-4">
                            <small class="text-muted">Balance</small>
                            <div class="font-weight-bold text-primary">
                                <?php echo e(number_format($balance, 2)); ?>

                            </div>
                        </div>
                    </div>

                    <?php if($tx->credit > 0 && $relatedExpense): ?>
                        <button type="button" class="btn btn-sm btn-info btn-block" data-toggle="modal" data-target="#viewModalMobile<?php echo e($tx->id); ?>">
                            <i class="fas fa-eye"></i> View Details
                        </button>

                        
                        <div class="modal fade" id="viewModalMobile<?php echo e($tx->id); ?>" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Transaction Details</h5>
                                        <button type="button" class="close" data-dismiss="modal">
                                            <span>&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="mb-3">
                                            <strong>Date:</strong> <?php echo e($tx->journalEntry->date->format('d M Y')); ?>

                                        </div>
                                        <div class="mb-3">
                                            <strong>Amount:</strong> <?php echo e(number_format($tx->credit, 2)); ?>

                                        </div>
                                        <div class="mb-3">
                                            <strong>Description:</strong><br>
                                            <?php echo e($relatedExpense->description); ?>

                                        </div>
                                        <div class="mb-3">
                                            <strong>Expense Account:</strong><br>
                                            <?php echo e($relatedExpense->expenseAccount->code); ?> - <?php echo e($relatedExpense->expenseAccount->name); ?>

                                        </div>
                                        <?php if($relatedExpense->receipt_images && count($relatedExpense->receipt_images) > 0): ?>
                                            <div class="mb-3">
                                                <strong>Receipt Images:</strong><br>
                                                <div class="row">
                                                    <?php $__currentLoopData = $relatedExpense->receipt_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-12 mb-3">
                                                            <a href="<?php echo e(asset('storage/' . $image)); ?>" target="_blank">
                                                                <img src="<?php echo e(asset('storage/' . $image)); ?>"
                                                                     class="img-fluid img-thumbnail"
                                                                     alt="Receipt">
                                                            </a>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <div class="alert alert-info">
                                                <i class="fas fa-info-circle"></i> No receipt images attached to this expense.
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center text-muted py-3">
                <i class="fas fa-inbox fa-2x mb-2"></i>
                <p>No transactions found for this month.</p>
            </div>
        <?php endif; ?>
    </div>

    <div class="card-footer text-right">
        <strong>Current Balance:
            <?php echo e(number_format($account->balance, 2)); ?>

        </strong>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laravel\rms\resources\views/admin/pettycash/my-ledger.blade.php ENDPATH**/ ?>