<?php $__env->startSection('title', 'Employee Details'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Employee Details: <?php echo e($employee->full_name); ?></h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <?php if($employee->photo): ?>
                        <img src="<?php echo e(asset('storage/' . $employee->photo)); ?>" alt="<?php echo e($employee->full_name); ?>" class="img-fluid rounded-circle" style="max-width: 200px;">
                    <?php else: ?>
                        <div class="bg-secondary rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 200px; height: 200px;">
                            <i class="fas fa-user fa-5x text-white"></i>
                        </div>
                    <?php endif; ?>
                    <h3 class="mt-3"><?php echo e($employee->full_name); ?></h3>
                    <?php if($employee->full_name_ar): ?>
                        <p class="text-muted"><?php echo e($employee->full_name_ar); ?></p>
                    <?php endif; ?>
                    <p><strong><?php echo e($employee->employee_id); ?></strong></p>
                    <p>
                        <?php switch($employee->status):
                            case ('active'): ?>
                                <span class="badge badge-success badge-lg">Active</span>
                                <?php break; ?>
                            <?php case ('on_leave'): ?>
                                <span class="badge badge-warning badge-lg">On Leave</span>
                                <?php break; ?>
                            <?php case ('suspended'): ?>
                                <span class="badge badge-danger badge-lg">Suspended</span>
                                <?php break; ?>
                            <?php case ('terminated'): ?>
                                <span class="badge badge-dark badge-lg">Terminated</span>
                                <?php break; ?>
                        <?php endswitch; ?>
                    </p>
                    <div class="mt-3">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit employees')): ?>
                            <a href="<?php echo e(route('admin.hr.employees.edit', $employee)); ?>" class="btn btn-primary btn-block">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">User Account</h3>
                </div>
                <div class="card-body">
                    <?php if($employee->user_id): ?>
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle"></i> This employee has a user account.
                        </div>
                        <table class="table table-sm">
                            <tr>
                                <th>User Name:</th>
                                <td><?php echo e($employee->user->name); ?></td>
                            </tr>
                            <tr>
                                <th>Email:</th>
                                <td><?php echo e($employee->user->email); ?></td>
                            </tr>
                            <tr>
                                <th>Role:</th>
                                <td>
                                    <?php $__currentLoopData = $employee->user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge badge-info"><?php echo e(ucfirst($role->name)); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                            </tr>
                        </table>
                    <?php else: ?>
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i> This employee does not have a user account yet.
                        </div>
                        <?php if($employee->email): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage employees')): ?>
                                <a href="<?php echo e(route('admin.hr.employees.create-user', $employee)); ?>" class="btn btn-success btn-block">
                                    <i class="fas fa-user-plus"></i> Create User Account
                                </a>
                            <?php endif; ?>
                        <?php else: ?>
                            <p class="text-danger"><i class="fas fa-times-circle"></i> Employee must have an email address to create a user account.</p>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Personal Information</h3>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <th width="30%">Nationality:</th>
                            <td><?php echo e($employee->nationality); ?></td>
                        </tr>
                        <tr>
                            <th>Gender:</th>
                            <td><?php echo e(ucfirst($employee->gender)); ?></td>
                        </tr>
                        <tr>
                            <th>Date of Birth:</th>
                            <td><?php echo e($employee->date_of_birth->format('d M Y')); ?> (<?php echo e($employee->age); ?> years old)</td>
                        </tr>
                        <tr>
                            <th>Marital Status:</th>
                            <td><?php echo e(ucfirst($employee->marital_status)); ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Contact Information</h3>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <th width="30%">Email:</th>
                            <td><?php echo e($employee->email ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Phone:</th>
                            <td><?php echo e($employee->phone); ?></td>
                        </tr>
                        <?php if($employee->phone_2): ?>
                            <tr>
                                <th>Phone 2:</th>
                                <td><?php echo e($employee->phone_2); ?></td>
                            </tr>
                        <?php endif; ?>
                        <?php if($employee->address): ?>
                            <tr>
                                <th>Address:</th>
                                <td><?php echo e($employee->address); ?></td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </div>
            </div>

            <?php if($employee->emergency_contact_name): ?>
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Emergency Contact</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th width="30%">Name:</th>
                                <td><?php echo e($employee->emergency_contact_name); ?></td>
                            </tr>
                            <tr>
                                <th>Phone:</th>
                                <td><?php echo e($employee->emergency_contact_phone); ?></td>
                            </tr>
                            <tr>
                                <th>Relationship:</th>
                                <td><?php echo e($employee->emergency_contact_relationship); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Employment Details</h3>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <th width="30%">Department:</th>
                            <td><?php echo e($employee->department->name ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Designation:</th>
                            <td><?php echo e($employee->designation->name ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Reporting Manager:</th>
                            <td><?php echo e($employee->reportingManager->name ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Employment Type:</th>
                            <td><?php echo e(ucfirst(str_replace('-', ' ', $employee->employment_type))); ?></td>
                        </tr>
                        <tr>
                            <th>Joining Date:</th>
                            <td><?php echo e($employee->joining_date->format('d M Y')); ?> (<?php echo e($employee->tenure); ?> years)</td>
                        </tr>
                        <tr>
                            <th>Probation Period:</th>
                            <td><?php echo e($employee->probation_period_days); ?> days</td>
                        </tr>
                        <?php if($employee->confirmation_date): ?>
                            <tr>
                                <th>Confirmation Date:</th>
                                <td><?php echo e($employee->confirmation_date->format('d M Y')); ?></td>
                            </tr>
                        <?php endif; ?>
                        <?php if($employee->status == 'terminated'): ?>
                            <tr>
                                <th>Termination Date:</th>
                                <td><?php echo e($employee->termination_date?->format('d M Y')); ?></td>
                            </tr>
                            <tr>
                                <th>Termination Reason:</th>
                                <td><?php echo e($employee->termination_reason); ?></td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </div>
            </div>

            <?php if($employee->currentSalary): ?>
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Current Salary</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th width="30%">Basic Salary:</th>
                                <td><?php echo e(number_format($employee->currentSalary->basic_salary, 2)); ?> AED</td>
                            </tr>
                            <tr>
                                <th>Housing Allowance:</th>
                                <td><?php echo e(number_format($employee->currentSalary->housing_allowance, 2)); ?> AED</td>
                            </tr>
                            <tr>
                                <th>Transport Allowance:</th>
                                <td><?php echo e(number_format($employee->currentSalary->transport_allowance, 2)); ?> AED</td>
                            </tr>
                            <tr>
                                <th>Other Allowances:</th>
                                <td><?php echo e(number_format($employee->currentSalary->other_allowances, 2)); ?> AED</td>
                            </tr>
                            <tr>
                                <th><strong>Gross Salary:</strong></th>
                                <td><strong><?php echo e(number_format($employee->currentSalary->gross_salary, 2)); ?> AED</strong></td>
                            </tr>
                            <tr>
                                <th>Effective From:</th>
                                <td><?php echo e($employee->currentSalary->effective_from->format('d M Y')); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laravel\rms\resources\views/admin/hr/employees/show.blade.php ENDPATH**/ ?>