<?php $__env->startSection('title', 'Employees'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Employees</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Employees</h3>
            <div class="card-tools">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create employees')): ?>
                    <a href="<?php echo e(route('admin.hr.employees.create')); ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add Employee
                    </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Employee ID</th>
                        <th>Photo</th>
                        <th>Name</th>
                        <th>Department</th>
                        <th>Designation</th>
                        <th>Phone</th>
                        <th>Status</th>
                        <th>User Account</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($employee->employee_id); ?></td>
                            <td>
                                <?php if($employee->photo): ?>
                                    <img src="<?php echo e(asset('storage/' . $employee->photo)); ?>" alt="<?php echo e($employee->full_name); ?>" class="img-thumbnail" style="width: 50px; height: 50px;">
                                <?php else: ?>
                                    <span class="text-muted">No photo</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($employee->full_name); ?></td>
                            <td><?php echo e($employee->department->name ?? 'N/A'); ?></td>
                            <td><?php echo e($employee->designation->name ?? 'N/A'); ?></td>
                            <td><?php echo e($employee->phone); ?></td>
                            <td>
                                <?php switch($employee->status):
                                    case ('active'): ?>
                                        <span class="badge badge-success">Active</span>
                                        <?php break; ?>
                                    <?php case ('on_leave'): ?>
                                        <span class="badge badge-warning">On Leave</span>
                                        <?php break; ?>
                                    <?php case ('suspended'): ?>
                                        <span class="badge badge-danger">Suspended</span>
                                        <?php break; ?>
                                    <?php case ('terminated'): ?>
                                        <span class="badge badge-dark">Terminated</span>
                                        <?php break; ?>
                                <?php endswitch; ?>
                            </td>
                            <td class="text-center">
                                <?php if($employee->user_id): ?>
                                    <span class="badge badge-success" title="Has user account">
                                        <i class="fas fa-check"></i> Yes
                                    </span>
                                <?php else: ?>
                                    <span class="badge badge-secondary" title="No user account">
                                        <i class="fas fa-times"></i> No
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('admin.hr.employees.show', $employee)); ?>" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit employees')): ?>
                                    <a href="<?php echo e(route('admin.hr.employees.edit', $employee)); ?>" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete employees')): ?>
                                    <form action="<?php echo e(route('admin.hr.employees.destroy', $employee)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center">No employees found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="card-footer">
            <?php echo e($employees->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laravel\rms\resources\views/admin/hr/employees/index.blade.php ENDPATH**/ ?>